package com.thebeastshop.cart.enums;

/**
 * @author feiLong.gao
 * @date 2019/12/30
 */
public enum ScJumpModeEnum {

    TEXT(1, "文本"),
    POSTAGE(2, "邮费"),
    CAMPAIGN(3, "活动"),
    ;

    private Integer id;
    private String name;

    ScJumpModeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }


    public static ScJumpModeEnum getEnumByCode(Integer id) {
        for (ScJumpModeEnum e : ScJumpModeEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }
}
