package com.thebeastshop.cart.model;

import com.thebeastshop.cart.enums.CartGroupTypeEnum;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * 购物车分组
 *
 * @author feiLong.gao
 * @date 2019/12/25
 */
public class ScGroupsVO extends BaseDO {

    /**
     * 标题
     */
    private String title;               // 标题
    /**
     * 描述
     */
    private String description;         //描述

    private Boolean exclusive;           //独有标识：若为 true，表明该 group 的商品，不能与其他 group 同时选中。海外购的 group，该值设置为 true

    private List<ScPackVO> packs;        //商品包

    private CartGroupTypeEnum type;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getExclusive() {
        return exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public List<ScPackVO> getPacks() {
        return packs;
    }

    public void setPacks(List<ScPackVO> packs) {
        this.packs = packs;
    }

    public CartGroupTypeEnum getType() {
        return type;
    }

    public void setType(CartGroupTypeEnum type) {
        this.type = type;
    }
}
