package com.thebeastshop.cart.enums;

/**
 * @author feiLong.gao
 * @date 2019/12/26
 */
public enum FavoriteExtTypeEnum {
    PRODUCT(1, "商品"),
    ARTICLE(2, "文章"),
    ;

    private Integer id;
    private String name;

    FavoriteExtTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static FavoriteExtTypeEnum getEnumByCode(Integer id) {
        for (FavoriteExtTypeEnum e : FavoriteExtTypeEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }
}
