package com.thebeastshop.cart.model.group;

import com.thebeastshop.cart.enums.CartGroupTypeEnum;
import com.thebeastshop.cart.model.ScPackBox;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * Author : feilong.gao
 * email : feilong.gao.thebeastshop.com
 * date : 2020/8/10
 */
public abstract class CartGroup extends BaseDO {

    /**
     * 标题
     */
    private String title;
    /**
     * 描述
     */
    private String description;

    /**
     *  独有标识：若为 true，表明该 group 的商品，不能与其他 group 同时选中。海外购的 group，该值设置为 true
     */
    private Boolean exclusive;

    /**
     *
     * @enum CartGroupTypeEnum OVERSEA - 海外直邮  NORMAL - 普通商品
     */
    private CartGroupTypeEnum type;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getExclusive() {
        return exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public CartGroupTypeEnum getType() {
        return type;
    }

    public void setType(CartGroupTypeEnum type) {
        this.type = type;
    }
}
