package com.thebeastshop.cart.service;


import com.thebeastshop.cart.model.ScPackVO;
import com.thebeastshop.cart.req.ShopCartReq;
import com.thebeastshop.cart.resp.ScCartResp;
import com.thebeastshop.cart.resp.ScMiniCartResp;
import com.thebeastshop.cart.resp.ScPreviewResp;
import com.thebeastshop.common.ServiceResp;

import java.util.List;

/**
 * 购物服务接口
 * <p>
 * Created by GFL on 2019/5/24.
 */
public interface ShopCartService {


    ServiceResp<ScPreviewResp> previewCart(ShopCartReq req);


    ServiceResp<ScCartResp> getCart(ShopCartReq req);

    ServiceResp<ScMiniCartResp> getMinCart(ShopCartReq req);

    ServiceResp<Integer> getCartSize(ShopCartReq req);


    ServiceResp<List<Long>> addCart(ShopCartReq req);


    ServiceResp<List<ScPackVO>> editCartPack(ShopCartReq req);


    ServiceResp<Boolean> removeCartPack(ShopCartReq req);


    ServiceResp<Boolean> clearInvalidCartPack(ShopCartReq req);

}
