package com.thebeastshop.cart.resp;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.support.ScDeliveryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

/**
 * 购物车-商品包关系。后面对应着一个表。
 *
 * @author Liang Wenjian
 */
public class CartProductPack implements ProductPack, Serializable {

    /**
     * @Field long serialVersionUID
     */
    private static final long serialVersionUID = 1L;

    private Long id;
    private Long ownerId;
    private Long spvId;
    private PsSpvVO spv;
    private Long productId;
    private PsProductVO product;
    private BigDecimal factProductPrice;
    private BigDecimal customizePrice;
    private int count = 1;
    private int storeCount;
    private int warehouseCount;
    private List<ScDeliveryVO> deliverys;
    private CartPackSourceEnum source = CartPackSourceEnum.RAW;
    private boolean valid = true;
    private boolean isCustomize = false;
    private List<CartCustomization> customizeList;
    private List<CartProductPack> giftPacks;
    private Date createTime;
    private String sourceBindVal;
    private Integer limitCount;     // 赠品或换购商品总数
    /**
     * 是否需要扎丝带
     */
    private Boolean needCorses = false;

    public CartProductPack() {
        super();
    }

    public CartProductPack(ProductPack pack, Long ownerId) {
        super();
        this.setId(pack.getId());
        this.setCount(pack.getCount());
        this.setCreateTime(pack.getCreateTime());
        this.setFactProductPrice(pack.getFactProductPrice());
        this.setSource(pack.getSource());
        this.setSpvId(pack.getSpvId());
        this.setProductId(pack.getProductId());
        this.setValid(pack.isValid());
        this.setOwnerId(ownerId);
    }

    public Long getId() {
        return id;
    }

    public void setId(final Long id) {
        this.id = id;
    }

    @Override
    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(final Long spvId) {
        this.spvId = spvId;
    }

    @Override
    public BigDecimal getFactProductPrice() {
        return factProductPrice;
    }

    public void setFactProductPrice(final BigDecimal factProductPrice) {
        this.factProductPrice = factProductPrice;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getStoreCount() {
        return storeCount;
    }

    public void setStoreCount(int storeCount) {
        this.storeCount = storeCount;
    }

    public int getWarehouseCount() {
        return warehouseCount;
    }

    public void setWarehouseCount(int warehouseCount) {
        this.warehouseCount = warehouseCount;
    }

    public boolean isValid() {
        return valid;
    }

    public void setValid(final boolean valid) {
        this.valid = valid;
    }

    public List<ScDeliveryVO> getDeliverys() {
        return deliverys;
    }

    public void setDeliverys(List<ScDeliveryVO> deliverys) {
        this.deliverys = deliverys;
    }

    public CartPackSourceEnum getSource() {
        return source;
    }

    public void setSource(CartPackSourceEnum source) {
        this.source = source;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(final Date createTime) {
        this.createTime = createTime;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public BigDecimal getPrice() {
        return getFactProductPrice().multiply(BigDecimal.valueOf(count).setScale(2, RoundingMode.HALF_UP));
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public PsSpvVO getSpv() {
        return spv;
    }

    public void setSpv(PsSpvVO spv) {
        this.spv = spv;
    }

    public PsProductVO getProduct() {
        return product;
    }

    public void setProduct(PsProductVO product) {
        this.product = product;
    }

    @Override
    public boolean isCustomize() {
        return isCustomize;
    }

    public void setCustomize(boolean customize) {
        isCustomize = customize;
    }

    @Override
    public List<CartCustomization> getCustomizeList() {
        return customizeList;
    }

    public void setCustomizeList(List<CartCustomization> customizeList) {
        this.customizeList = customizeList;
    }

    public List<CartProductPack> getGiftPacks() {
        return giftPacks;
    }

    public void setGiftPacks(List<CartProductPack> giftPacks) {
        this.giftPacks = giftPacks;
    }

    public BigDecimal getCustomizePrice() {
        return customizePrice;
    }

    public void setCustomizePrice(BigDecimal customizePrice) {
        this.customizePrice = customizePrice;
    }

    public String getSourceBindVal() {
        return sourceBindVal;
    }

    public void setSourceBindVal(String sourceBindVal) {
        this.sourceBindVal = sourceBindVal;
    }

    @Override
    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }

    public Boolean getNeedCorses() {
        return needCorses;
    }

    public void setNeedCorses(Boolean needCorses) {
        this.needCorses = needCorses;
    }

}
