package com.thebeastshop.cart.model.gift;

import com.thebeastshop.cart.enums.ScJumpModeEnum;
import com.thebeastshop.cart.model.ScCampaignTag;
import com.thebeastshop.cart.model.ScPackVO;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * @author feiLong.gao
 * @date 2019/12/25
 */
public class ScGiftCampaignVO extends BaseDO {

    private Integer id;            //活动ID
    private String name;           //活动名
    private ScCampaignTag tag;     //赠品活动标签
    private ScJumpModeEnum mode = ScJumpModeEnum.CAMPAIGN;   // 跳转Mode
    private String linkDesc;       //跳转显示文案
    private Boolean jump = false;    // 是否跳转
    private String tips;             // 活动提示语：本活动为阶梯式满赠，满足条件后所有阶梯赠品可同时赠送
    private String action;           // 活动动作
    private Boolean fulfilled;              // 是否满足活动
    private Boolean editable = Boolean.FALSE; // 是否可编辑
    private List<ScGiftSectionVO> sections;  // 活动阶梯信息
    private List<ScPackVO> gifts;  // 已选赠品集

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ScCampaignTag getTag() {
        return tag;
    }

    public void setTag(ScCampaignTag tag) {
        this.tag = tag;
    }

    public ScJumpModeEnum getMode() {
        return mode;
    }

    public void setMode(ScJumpModeEnum mode) {
        this.mode = mode;
    }

    public String getLinkDesc() {
        return linkDesc;
    }

    public void setLinkDesc(String linkDesc) {
        this.linkDesc = linkDesc;
    }

    public Boolean getJump() {
        return jump;
    }

    public void setJump(Boolean jump) {
        this.jump = jump;
    }

    public String getTips() {
        return tips;
    }

    public void setTips(String tips) {
        this.tips = tips;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Boolean getFulfilled() {
        return fulfilled;
    }

    public void setFulfilled(Boolean fulfilled) {
        this.fulfilled = fulfilled;
    }

    public Boolean getEditable() {
        return editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public List<ScGiftSectionVO> getSections() {
        return sections;
    }

    public void setSections(List<ScGiftSectionVO> sections) {
        this.sections = sections;
    }

    public List<ScPackVO> getGifts() {
        return gifts;
    }

    public void setGifts(List<ScPackVO> gifts) {
        this.gifts = gifts;
    }
}
