package com.thebeastshop.cart.vo;

import com.thebeastshop.support.mark.HasOwner;

import java.io.Serializable;
import java.util.List;

/**
 * 将商品包从某处（比如购物车）移到另一处（比如收藏）的dto。
 *
 * @author Liang Wenjian
 */
public class CartPacksTransferDTO implements HasOwner ,Serializable{

    public enum Destination {
        FAVORITE
    }

    private Destination to;
    private Long ownerId;
    private List<Long> packIds;

    public Destination getTo() {
        return to;
    }

    public void setTo(final Destination to) {
        this.to = to;
    }

    public List<Long> getPackIds() {
        return packIds;
    }

    public void setPackIds(final List<Long> packIds) {
        this.packIds = packIds;
    }

    @Override
    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(final Long ownerId) {
        this.ownerId = ownerId;
    }
}
