package com.thebeastshop.cart;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.support.mark.HasCount;
import com.thebeastshop.support.mark.HasOwner;
import com.thebeastshop.support.mark.HasPrice;

import java.math.BigDecimal;
import java.util.List;

/**
 * 临时购物车。 本对象后面没有对应着数据库表，所以只是一个dto
 *
 * @author Liang Wenjian
 */
public interface Cart extends HasOwner, HasPrice, HasCount {

	@Override
	Long getOwnerId();

	List<CartProductPack> getProductPacks();

	@Override
	int getCount();

	@Override
	BigDecimal getPrice();
}
