package com.thebeastshop.cart.resp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.util.PriceUtil;

/**
 * 临时购物车-商品包关系。后面对应着一个表。
 * 
 * @author Paul-xiong
 *
 */
public class TempCartProductPack implements ProductPack ,Serializable{

	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;
	
	private Long id;
	private String binding;
	private Long spvId;
	private PsSpvVO spv;
	private Long productId;
	private PsProductVO product;
	private BigDecimal factProductPrice;
	private int count = 1;
	private CartPackSource source = CartPackSource.RAW;
	private boolean valid = true;
	private boolean isCustomize = false;
	private List<CartCustomization> customizeList;
	private Date createTime;
	private String tbsId;
    private Integer limitCount;     // 赠品或换购商品总数

	public TempCartProductPack() {
		super();
	}

	public String getTbsId() {
		return tbsId;
	}

	public void setTbsId(String tbsId) {
		this.tbsId = tbsId;
	}

	public TempCartProductPack(ProductPack pack, String binding) {
		super();
		this.setId(pack.getId());
		this.setCount(pack.getCount());
		this.setCreateTime(pack.getCreateTime());
		this.setFactProductPrice(pack.getFactProductPrice());
		this.setSource(pack.getSource());
		this.setProductId(pack.getProductId());
		this.setSpvId(pack.getSpvId());
		this.setValid(pack.isValid());
		this.setBinding(binding);
	}

	@Override
	public Long getId() {
		return id;
	}

	public void setId(final Long id) {
		this.id = id;
	}

	@Override
	public Long getSpvId() {
		return spvId;
	}

	public void setSpvId(final Long spvId) {
		this.spvId = spvId;
	}

	@Override
	public BigDecimal getFactProductPrice() {
		return factProductPrice;
	}

	public void setFactProductPrice(final BigDecimal factProductPrice) {
		this.factProductPrice = factProductPrice;
	}

	@Override
	public int getCount() {
		return count;
	}

	public void setCount(final int count) {
		this.count = count;
	}

	@Override
	public boolean isValid() {
		return valid;
	}

	public void setValid(final boolean valid) {
		this.valid = valid;
	}

	@Override
	public CartPackSource getSource() {
		return source;
	}

	public void setSource(final CartPackSource source) {
		this.source = source;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(final Date createTime) {
		this.createTime = createTime;
	}

	@Override
	public BigDecimal getPrice() {
		return PriceUtil.multiPrice(getFactProductPrice(), getCount());
	}

	public String getBinding() {
		return binding;
	}

	public void setBinding(String binding) {
		this.binding = binding;
	}

	public Long getProductId() {
		return productId;
	}

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public PsSpvVO getSpv() {
		return spv;
	}

	public void setSpv(PsSpvVO spv) {
		this.spv = spv;
	}

	public PsProductVO getProduct() {
		return product;
	}

	public void setProduct(PsProductVO product) {
		this.product = product;
	}

	@Override
	public boolean isCustomize() {
		return isCustomize;
	}

	public void setCustomize(boolean customize) {
		isCustomize = customize;
	}

	@Override
	public List<CartCustomization> getCustomizeList() {
		return customizeList;
	}

	public void setCustomizeList(List<CartCustomization> customizeList) {
		this.customizeList = customizeList;
	}

	@Override
	public String getSourceBindVal() {
		return null;
	}

    @Override
    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    @Override
	public String toString() {
    	return JSON.toJSONString(this);
	}
	
}
