package com.thebeastshop.cart;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thebeastshop.cart.resp.TempCartProductPack;
import com.thebeastshop.support.mark.HasCount;
import com.thebeastshop.support.mark.HasPrice;

import java.math.BigDecimal;
import java.util.List;

/**
 * 购物车。 本对象后面没有对应着数据库表，所以只是一个dto
 * 
 * @author Paul-xiong
 *
 */
public interface TempCart extends HasPrice, HasCount {

	String getBinding();

	List<TempCartProductPack> getProductPacks();

	@Override
	int getCount();

	@Override
	BigDecimal getPrice();
}
