package com.thebeastshop.cart.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.BaseDO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.vo.cart.DeliveryVO;

/**
 * <p>Title: thebeastshop</p>
 * <p>Copyright: Copyright (c) 2017</p>
 * @author Bryan Zhang
 * @date 2017-2-23
 * @description 
 */
public class CartProductPack extends BaseDO {

	private static final long serialVersionUID = 1L;

	private Long id;
	private Long ownerId;
	private Long spvId;
	private PsSpvVO spv;
	private Long productId;
	private PsProductVO product;
	private BigDecimal factProductPrice;
	private BigDecimal customizePrice;
	private int count = 1;
	private int storeCount;
	private int warehouseCount;
    private List<DeliveryVO> deliverys;
	private CartPackSourceEnum source = CartPackSourceEnum.RAW;
	private boolean valid = true;
	private boolean isCustomize = false;
	private List<CartCustomization> customizeList;
	private List<CartProductPack> giftPacks;
	
	private Date createTime;
	
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getOwnerId() {
		return ownerId;
	}
	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
	}
	public Long getSpvId() {
		return spvId;
	}
	public void setSpvId(Long spvId) {
		this.spvId = spvId;
	}
	public PsSpvVO getSpv() {
		return spv;
	}
	public void setSpv(PsSpvVO spv) {
		this.spv = spv;
	}
	public Long getProductId() {
		return productId;
	}
	public void setProductId(Long productId) {
		this.productId = productId;
	}
	public PsProductVO getProduct() {
		return product;
	}
	public void setProduct(PsProductVO product) {
		this.product = product;
	}
	public BigDecimal getFactProductPrice() {
		return factProductPrice;
	}
	public void setFactProductPrice(BigDecimal factProductPrice) {
		this.factProductPrice = factProductPrice;
	}
	public BigDecimal getCustomizePrice() {
		return customizePrice;
	}
	public void setCustomizePrice(BigDecimal customizePrice) {
		this.customizePrice = customizePrice;
	}
	public int getCount() {
		return count;
	}
	public void setCount(int count) {
		this.count = count;
	}
	public int getStoreCount() {
		return storeCount;
	}
	public void setStoreCount(int storeCount) {
		this.storeCount = storeCount;
	}
	public int getWarehouseCount() {
		return warehouseCount;
	}
	public void setWarehouseCount(int warehouseCount) {
		this.warehouseCount = warehouseCount;
	}
	public List<DeliveryVO> getDeliverys() {
		return deliverys;
	}
	public void setDeliverys(List<DeliveryVO> deliverys) {
		this.deliverys = deliverys;
	}
	public CartPackSourceEnum getSource() {
		return source;
	}
	public void setSource(CartPackSourceEnum source) {
		this.source = source;
	}
	public boolean isValid() {
		return valid;
	}
	public void setValid(boolean valid) {
		this.valid = valid;
	}
	public boolean isCustomize() {
		return isCustomize;
	}
	public void setCustomize(boolean isCustomize) {
		this.isCustomize = isCustomize;
	}
	public List<CartCustomization> getCustomizeList() {
		return customizeList;
	}
	public void setCustomizeList(List<CartCustomization> customizeList) {
		this.customizeList = customizeList;
	}
	public List<CartProductPack> getGiftPacks() {
		return giftPacks;
	}
	public void setGiftPacks(List<CartProductPack> giftPacks) {
		this.giftPacks = giftPacks;
	}
	public Date getCreateTime() {
		return createTime;
	}
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
}
