package com.thebeastshop.cart.support;


import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.mark.HasIdGetter.HasLongId;
import com.thebeastshop.support.util.PriceUtil;

/**
 * @author Liang Wenjian
 */
public class DefaultProductPackImpl implements ProductPack, HasLongId ,Serializable {

	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;
	private Long id;
	private Long spvId;
	private PsSpvVO spv;
	private Long productId;
	private PsProductVO product;
	private BigDecimal factProductPrice;
	private int count = 1;
	private CartPackSource source = CartPackSource.RAW;
	private boolean valid = true;
	private Date createTime;
	private BuyQuota buyQuota;
    private Integer limitCount;     // 满赠赠品或者换购商品总数

	public DefaultProductPackImpl() {
		super();
	}

	@Override
	public Long getId() {
		return id;
	}

	@Override
	public void setId(final Long id) {
		this.id = id;
	}

	@Override
	public Long getSpvId() {
		return spvId;
	}

	public void setSpvId(final Long spvId) {
		this.spvId = spvId;
	}

	@Override
	public BigDecimal getFactProductPrice() {
		return factProductPrice;
	}

	public void setFactProductPrice(final BigDecimal factProductPrice) {
		this.factProductPrice = factProductPrice;
	}

	@Override
	public int getCount() {
		return count;
	}

	@Override
	public void setCount(int count) {
		this.count = count;
	}

	@Override
	public boolean isValid() {
		return valid;
	}

	public void setValid(final boolean valid) {
		this.valid = valid;
	}

	@Override
	public CartPackSource getSource() {
		return source;
	}

	public void setSource(final CartPackSource source) {
		this.source = source;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(final Date createTime) {
		this.createTime = createTime;
	}

	public Long getProductId() {
		return productId;
	}

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public PsSpvVO getSpv() {
		return spv;
	}

	public void setSpv(PsSpvVO spv) {
		this.spv = spv;
	}

	public PsProductVO getProduct() {
		return product;
	}

	public void setProduct(PsProductVO product) {
		this.product = product;
	}

	@Override
	public BigDecimal getPrice() {
		return PriceUtil.multiPrice(getFactProductPrice(), getCount());
	}

	@Override
	public boolean isCustomize() {
		return false;
	}

	@Override
	public List<CartCustomization> getCustomizeList() {
		return null;
	}

	@Override
	public String getSourceBindVal() {
		return null;
	}

	public BuyQuota getBuyQuota() {
		return buyQuota;
	}

	public void setBuyQuota(BuyQuota buyQuota) {
		this.buyQuota = buyQuota;
	}

    @Override
    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }
}
