/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.campaign.enums;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum ConditionTypeEnum {
    PRICE(1, "\u91d1\u989d"){

        @Override
        public boolean matchCondition(BigDecimal price, int productCount, BigDecimal conditionNum) {
            if (conditionNum.compareTo(BigDecimal.ZERO) <= 0) {
                return true;
            }
            return price.compareTo(conditionNum) >= 0;
        }

        @Override
        public int cumulate(BigDecimal line, BigDecimal participatePrice, int participateCount) {
            return participatePrice.divide(line, RoundingMode.HALF_UP).intValue();
        }
    }
    ,
    PRODUCT_COUNT(2, "\u5546\u54c1\u6570\u91cf"){

        @Override
        public boolean matchCondition(BigDecimal price, int productCount, BigDecimal conditionNum) {
            if (conditionNum.compareTo(BigDecimal.ZERO) <= 0) {
                return true;
            }
            return productCount >= conditionNum.intValue();
        }

        @Override
        public int cumulate(BigDecimal line, BigDecimal participatePrice, int participateCount) {
            return participateCount / line.intValue();
        }
    };

    public static final List<ConditionTypeEnum> ALL;
    private final Integer id;
    private final String name;

    private ConditionTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public abstract boolean matchCondition(BigDecimal var1, int var2, BigDecimal var3);

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public abstract int cumulate(BigDecimal var1, BigDecimal var2, int var3);

    public static ConditionTypeEnum getEnumById(Integer id) {
        for (ConditionTypeEnum item : ConditionTypeEnum.values()) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(ConditionTypeEnum.values()));
    }
}

