/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.thebeastshop.bi.dao.ReportingDataEventRetentionMapper;
import com.thebeastshop.bi.dao.ReportingDataEventUvMapper;
import com.thebeastshop.bi.dao.ReportingDataPageCtrMapper;
import com.thebeastshop.bi.dto.BiReportCondDTO;
import com.thebeastshop.bi.dto.BiVariablesDetailsDTO;
import com.thebeastshop.bi.dto.ReportingBaseBiChartDataCtrDTO;
import com.thebeastshop.bi.dto.ReportingBaseBiChartDataEventRetentionDTO;
import com.thebeastshop.bi.dto.ReportingBaseBiChartDataEventUvDTO;
import com.thebeastshop.bi.po.ReportingDataEventRetention;
import com.thebeastshop.bi.po.ReportingDataEventRetentionExample;
import com.thebeastshop.bi.po.ReportingDataEventUv;
import com.thebeastshop.bi.po.ReportingDataEventUvExample;
import com.thebeastshop.bi.po.ReportingDataPageCtr;
import com.thebeastshop.bi.po.ReportingDataPageCtrExample;
import com.thebeastshop.bi.service.ReportingBaseBiChartDataService;
import com.thebeastshop.bi.utils.DateTool;
import com.thebeastshop.common.utils.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportingBaseBiChartDataServiceImpl
implements ReportingBaseBiChartDataService {
    @Autowired
    private ReportingDataPageCtrMapper reportingDataPageCtrMapper;
    @Autowired
    private ReportingDataEventUvMapper reportingDataEventUvMapper;
    @Autowired
    private ReportingDataEventRetentionMapper reportingDataEventRetentionMapper;

    public List<ReportingBaseBiChartDataCtrDTO> findDataPageCtr(BiReportCondDTO dto) {
        ArrayList<ReportingBaseBiChartDataCtrDTO> reportingBaseBiChartDataCtrDTOList = new ArrayList<ReportingBaseBiChartDataCtrDTO>();
        Long from = Long.valueOf(DateTool.stringToString((String)dto.getRange().getFrom(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        Long to = Long.valueOf(DateTool.stringToString((String)dto.getRange().getTo(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        String traget = ((BiVariablesDetailsDTO)dto.getVariables().get(0)).getName();
        ReportingDataPageCtrExample example = new ReportingDataPageCtrExample();
        example.createCriteria().andTimeGreaterThanOrEqualTo(from).andTimeLessThanOrEqualTo(to).andPageEqualTo(traget);
        example.setOrderByClause("time");
        List list = this.reportingDataPageCtrMapper.selectByExample(example);
        if (list == null) {
            return null;
        }
        for (ReportingDataPageCtr reportingDataPageCtr : list) {
            ReportingBaseBiChartDataCtrDTO reportingBaseBiChartDataCtrDTO = (ReportingBaseBiChartDataCtrDTO)BeanUtil.buildFrom((Object)reportingDataPageCtr, ReportingBaseBiChartDataCtrDTO.class);
            String monthDay = reportingBaseBiChartDataCtrDTO.getTime().toString().substring(4, 6) + "/" + reportingBaseBiChartDataCtrDTO.getTime().toString().substring(6, 8);
            reportingBaseBiChartDataCtrDTO.setMonthDay(monthDay);
            reportingBaseBiChartDataCtrDTOList.add(reportingBaseBiChartDataCtrDTO);
        }
        return reportingBaseBiChartDataCtrDTOList;
    }

    public static void main(String[] args) {
        String str = "20170801";
        System.out.println(str.substring(6, 8));
    }

    public List<ReportingBaseBiChartDataEventUvDTO> findDataEventUv(BiReportCondDTO dto) {
        ArrayList<ReportingBaseBiChartDataEventUvDTO> reportingBaseBiChartDataEventUvDTOList = new ArrayList<ReportingBaseBiChartDataEventUvDTO>();
        Long from = Long.valueOf(DateTool.stringToString((String)dto.getRange().getFrom(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        Long to = Long.valueOf(DateTool.stringToString((String)dto.getRange().getTo(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        Long lastFrom = from - 10000L;
        Long lastTo = to - 10000L;
        String traget = ((BiVariablesDetailsDTO)dto.getVariables().get(0)).getName();
        String rangeFlag = ((BiVariablesDetailsDTO)dto.getVariables().get(1)).getValue();
        ReportingDataEventUvExample example = new ReportingDataEventUvExample();
        example.createCriteria().andEventDayGreaterThanOrEqualTo(from).andEventDayLessThanOrEqualTo(to).andEventTargetEqualTo(traget).andRangeFlagEqualTo(rangeFlag);
        example.setOrderByClause("event_day");
        List list = this.reportingDataEventUvMapper.selectByExample(example);
        if (list == null) {
            return null;
        }
        for (ReportingDataEventUv reportingDataEventUv : list) {
            ReportingBaseBiChartDataEventUvDTO reportingBaseBiChartDataEventUvDTO = (ReportingBaseBiChartDataEventUvDTO)BeanUtil.buildFrom((Object)reportingDataEventUv, ReportingBaseBiChartDataEventUvDTO.class);
            reportingBaseBiChartDataEventUvDTO.setYear(Integer.valueOf(2018));
            String monthDay = reportingBaseBiChartDataEventUvDTO.getEventDay().toString().substring(4, 6) + "/" + reportingBaseBiChartDataEventUvDTO.getEventDay().toString().substring(6, 8);
            reportingBaseBiChartDataEventUvDTO.setMonthDay(monthDay);
            reportingBaseBiChartDataEventUvDTOList.add(reportingBaseBiChartDataEventUvDTO);
        }
        ReportingDataEventUvExample lastExample = new ReportingDataEventUvExample();
        lastExample.createCriteria().andEventDayGreaterThanOrEqualTo(lastFrom).andEventDayLessThanOrEqualTo(lastTo).andEventTargetEqualTo(traget).andRangeFlagEqualTo(rangeFlag);
        lastExample.setOrderByClause("event_day");
        List lastYearList = this.reportingDataEventUvMapper.selectByExample(lastExample);
        if (lastYearList == null) {
            return null;
        }
        for (ReportingDataEventUv reportingDataEventUv : lastYearList) {
            ReportingBaseBiChartDataEventUvDTO reportingBaseBiChartDataEventUvDTO = (ReportingBaseBiChartDataEventUvDTO)BeanUtil.buildFrom((Object)reportingDataEventUv, ReportingBaseBiChartDataEventUvDTO.class);
            reportingBaseBiChartDataEventUvDTO.setYear(Integer.valueOf(2017));
            String monthDay = reportingBaseBiChartDataEventUvDTO.getEventDay().toString().substring(4, 6) + "/" + reportingBaseBiChartDataEventUvDTO.getEventDay().toString().substring(6, 8);
            reportingBaseBiChartDataEventUvDTO.setMonthDay(monthDay);
            reportingBaseBiChartDataEventUvDTOList.add(reportingBaseBiChartDataEventUvDTO);
        }
        return reportingBaseBiChartDataEventUvDTOList;
    }

    public List<ReportingBaseBiChartDataEventRetentionDTO> findDataEventRetention(BiReportCondDTO dto) {
        ArrayList<ReportingBaseBiChartDataEventRetentionDTO> reportingBaseBiChartDataEventRetentionDTOList = new ArrayList<ReportingBaseBiChartDataEventRetentionDTO>();
        Long from = Long.valueOf(DateTool.stringToString((String)dto.getRange().getFrom(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        Long to = Long.valueOf(DateTool.stringToString((String)dto.getRange().getTo(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS Z"));
        String traget = ((BiVariablesDetailsDTO)dto.getVariables().get(0)).getName();
        ReportingDataEventRetentionExample example = new ReportingDataEventRetentionExample();
        example.createCriteria().andEventDayGreaterThanOrEqualTo(from).andEventDayLessThanOrEqualTo(to).andTargetEqualTo(traget);
        example.setOrderByClause("event_day");
        String uv = ((BiVariablesDetailsDTO)dto.getVariables().get(1)).getValue();
        List list = new ArrayList();
        if (uv.equals("1")) {
            list = this.reportingDataEventRetentionMapper.selectByExampleNew1(example);
        } else if (uv.equals("7")) {
            list = this.reportingDataEventRetentionMapper.selectByExampleNew7(example);
        } else if (uv.equals("14")) {
            list = this.reportingDataEventRetentionMapper.selectByExampleNew14(example);
        } else if (uv.equals("21")) {
            list = this.reportingDataEventRetentionMapper.selectByExampleNew21(example);
        }
        if (list == null) {
            return null;
        }
        for (ReportingDataEventRetention reportingDataEventRetention : list) {
            ReportingBaseBiChartDataEventRetentionDTO reportingBaseBiChartDataEventRetentionDTO = (ReportingBaseBiChartDataEventRetentionDTO)BeanUtil.buildFrom((Object)reportingDataEventRetention, ReportingBaseBiChartDataEventRetentionDTO.class);
            String monthDay = reportingBaseBiChartDataEventRetentionDTO.getEventDay().toString().substring(4, 6) + "/" + reportingBaseBiChartDataEventRetentionDTO.getEventDay().toString().substring(6, 8);
            reportingBaseBiChartDataEventRetentionDTO.setMonthDay(monthDay);
            reportingBaseBiChartDataEventRetentionDTOList.add(reportingBaseBiChartDataEventRetentionDTO);
        }
        return reportingBaseBiChartDataEventRetentionDTOList;
    }
}

