/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.google.common.collect.Lists;
import com.thebeastshop.bi.dao.OpStorePassengerFlowMapper;
import com.thebeastshop.bi.dataSource.DynamicDataSource;
import com.thebeastshop.bi.dto.OpCustomerImportSearchCondDTO;
import com.thebeastshop.bi.dto.OpStorePassengerFlowDTO;
import com.thebeastshop.bi.po.OpStorePassengerFlow;
import com.thebeastshop.bi.service.OpCustomerImportService;
import com.thebeastshop.bi.vo.OpStorePassengerFlowVO;
import com.thebeastshop.common.PageQueryResp;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="opCustomerImportService")
public class OpCustomerImportServiceImpl
implements OpCustomerImportService {
    @Autowired
    private OpStorePassengerFlowMapper opStorePassengerFlowMapper;
    private static final Logger log = LoggerFactory.getLogger(OpCustomerImportServiceImpl.class);

    public Integer batchInsertRecords(List<OpStorePassengerFlowDTO> opStorePassengerFlowDTOS) throws InvocationTargetException, IllegalAccessException, ParseException {
        log.info("-----\u8fdb\u5165bi\u670d\u52a1");
        ArrayList opStorePassengerFlowList = Lists.newArrayList();
        for (OpStorePassengerFlowDTO dto : opStorePassengerFlowDTOS) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
            if (null == dto.getPassengerQuantity()) continue;
            String dateStr = sdf.format(dto.getImportDate());
            Date date = sdf2.parse(dateStr);
            dto.setImportDate(date);
            OpStorePassengerFlow opStorePassengerFlow = new OpStorePassengerFlow();
            BeanUtils.copyProperties((Object)opStorePassengerFlow, (Object)dto);
            opStorePassengerFlowList.add(opStorePassengerFlow);
        }
        DynamicDataSource.setDataSource((String)"mysqlData");
        log.info("-----\u5f00\u59cb\u63d2\u5165\u6570\u636eopStorePassengerFlowList size:" + opStorePassengerFlowList.size());
        Integer result = this.opStorePassengerFlowMapper.batchInsert((List)opStorePassengerFlowList);
        log.info("-----\u5f00\u59cb\u63d2\u5165\u6570\u636eresult:" + result);
        return 1;
    }

    public Integer batchUpdate(List<OpStorePassengerFlowDTO> opStorePassengerFlowDTOS) throws InvocationTargetException, IllegalAccessException {
        ArrayList opStorePassengerFlowList = Lists.newArrayList();
        for (OpStorePassengerFlowDTO dto : opStorePassengerFlowDTOS) {
            OpStorePassengerFlow opStorePassengerFlow = new OpStorePassengerFlow();
            BeanUtils.copyProperties((Object)opStorePassengerFlow, (Object)dto);
            opStorePassengerFlowList.add(opStorePassengerFlow);
        }
        DynamicDataSource.setDataSource((String)"mysqlData");
        return this.opStorePassengerFlowMapper.batchUpdate((List)opStorePassengerFlowList);
    }

    public PageQueryResp<OpStorePassengerFlowVO> queryMemberLabelPageByDto(OpCustomerImportSearchCondDTO dto) throws InvocationTargetException, IllegalAccessException {
        int count;
        SimpleDateFormat sdf;
        DynamicDataSource.setDataSource((String)"mysqlData");
        PageQueryResp page = new PageQueryResp();
        if (dto.getChannelCode().equals("null")) {
            dto.setChannelCode("");
        }
        HashMap<String, Integer> qualityMap = new HashMap<String, Integer>();
        List list = this.opStorePassengerFlowMapper.findStorePassengerFlowByCond(dto);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (OpStorePassengerFlow opStorePassengerFlow : list) {
                String dateStr = sdf.format(opStorePassengerFlow.getImportDate());
                qualityMap.put(opStorePassengerFlow.getChannelCode() + dateStr, opStorePassengerFlow.getPassengerQuantity());
            }
        }
        if (StringUtils.isEmpty((String)dto.getImportTimeBegin()) && (this.opStorePassengerFlowMapper.checkIfEmpty() <= 0 || this.opStorePassengerFlowMapper.checkIfHasRecord(dto) <= 0)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            dto.setImportTimeBegin(sdf.format(new Date()));
        }
        if ((count = this.opStorePassengerFlowMapper.countByCond(dto).intValue()) > 0) {
            List resultList = this.opStorePassengerFlowMapper.findByCond(dto);
            for (OpStorePassengerFlowVO vo : resultList) {
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                String dateStr = sdf2.format(vo.getImportDate());
                if (qualityMap.get(vo.getChannelCode() + dateStr) == null) continue;
                vo.setPassengerQuantity((Integer)qualityMap.get(vo.getChannelCode() + dateStr));
            }
            page.setBeanList(resultList);
            page.setPageSize(dto.getPagenum());
            page.setPageNo(dto.getCurrpage());
            page.setTotalCnt(Integer.valueOf(count));
        }
        return page;
    }
}

