/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.thebeastshop.bi.dao.OpChannelTargetMapper;
import com.thebeastshop.bi.dataSource.DynamicDataSource;
import com.thebeastshop.bi.dto.OpChannelTargetDTO;
import com.thebeastshop.bi.dto.OpChannelTargetSearchCondDTO;
import com.thebeastshop.bi.po.OpChannelTarget;
import com.thebeastshop.bi.service.OpChannelTargetService;
import com.thebeastshop.bi.vo.OpChannelTargetVO;
import com.thebeastshop.common.PageQueryResp;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="opChannelTargetService")
public class OpChannelTargetServiceImpl
implements OpChannelTargetService {
    @Autowired
    private OpChannelTargetMapper opChannelTargetMapper;

    public Integer batchInsert(List<OpChannelTargetDTO> channelTargetDTOS) {
        DynamicDataSource.setDataSource((String)"mysqlData");
        return this.opChannelTargetMapper.batchInsert(channelTargetDTOS);
    }

    public PageQueryResp<OpChannelTargetVO> queryChannelTargetPageByDto(OpChannelTargetSearchCondDTO dto) throws InvocationTargetException, IllegalAccessException {
        int count;
        DynamicDataSource.setDataSource((String)"mysqlData");
        PageQueryResp page = new PageQueryResp();
        if (dto.getChannelCode().equals("null")) {
            dto.setChannelCode("");
        }
        HashMap<String, Integer> qualityMap = new HashMap<String, Integer>();
        List list = this.opChannelTargetMapper.findChannelTargetByCond(dto);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (OpChannelTarget opChannelTarget : list) {
                String dateStr = sdf.format(opChannelTarget.getImportDate());
                qualityMap.put(opChannelTarget.getChannelCode() + dateStr, opChannelTarget.getChannleAchievementTarget());
            }
        }
        if ((count = this.opChannelTargetMapper.countByCond(dto).intValue()) > 0) {
            List resultList = this.opChannelTargetMapper.findByCond(dto);
            for (OpChannelTargetVO vo : resultList) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String dateStr = sdf.format(vo.getImportDate());
                if (qualityMap.get(vo.getChannelCode() + dateStr) != null) {
                    vo.setChannleAchievementTarget((Integer)qualityMap.get(vo.getChannelCode() + dateStr));
                    continue;
                }
                vo.setChannleAchievementTarget(Integer.valueOf(0));
            }
            page.setBeanList(resultList);
            page.setPageSize(dto.getPagenum());
            page.setPageNo(dto.getCurrpage());
            page.setTotalCnt(Integer.valueOf(count));
        }
        return page;
    }
}

