/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.bi.dao.IposOrderLineMapper;
import com.thebeastshop.bi.dao.IposOrderMapper;
import com.thebeastshop.bi.dataSource.DynamicDataSource;
import com.thebeastshop.bi.dto.IposOrderDTO;
import com.thebeastshop.bi.dto.IposOrderLineDTO;
import com.thebeastshop.bi.po.IposOrder;
import com.thebeastshop.bi.po.IposOrderExample;
import com.thebeastshop.bi.po.IposOrderLine;
import com.thebeastshop.bi.po.IposOrderLineExample;
import com.thebeastshop.bi.service.IposOrderService;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.utils.BeanUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="iposOrderService")
public class IposOrderServiceImpl
implements IposOrderService {
    @Autowired
    IposOrderMapper iposOrderMapper;
    @Autowired
    IposOrderLineMapper iposOrderLineMapper;

    public List<IposOrderDTO> queryChannelAndTime(String channel, Date startTime, Date endTime) {
        DynamicDataSource.setDataSource((String)"mysqlData");
        ArrayList iposOrderList = Lists.newArrayList();
        IposOrderExample example = new IposOrderExample();
        example.createCriteria().andChannelCodeEqualTo(channel).andTradeDateGreaterThanOrEqualTo(startTime).andTradeDateLessThan(endTime);
        example.setOrderByClause("type asc");
        List orderList = this.iposOrderMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return iposOrderList;
        }
        ArrayList orderCodes = Lists.newArrayList();
        for (IposOrder iposOrder : orderList) {
            orderCodes.add(iposOrder.getCode());
        }
        IposOrderLineExample lineExample = new IposOrderLineExample();
        lineExample.createCriteria().andCodeIn((List)orderCodes);
        List orderLineList = this.iposOrderLineMapper.selectByExample(lineExample);
        ConcurrentMap map = Maps.newConcurrentMap();
        for (IposOrderLine orderLine : orderLineList) {
            List tempList = (List)map.get(orderLine.getCode());
            if (tempList == null) {
                tempList = Lists.newArrayList((Object[])new IposOrderLine[]{orderLine});
            } else {
                tempList.add(orderLine);
            }
            map.put(orderLine.getCode(), tempList);
        }
        for (IposOrder iposOrder : orderList) {
            IposOrderDTO iposOrderDTO = this.buildIposOrder(iposOrder, (List)map.get(iposOrder.getCode()));
            if (iposOrderDTO == null) continue;
            iposOrderList.add(iposOrderDTO);
        }
        return iposOrderList;
    }

    public ServiceResp<IposOrderDTO> queryChannelAndCode(String channel, String orderCode) {
        DynamicDataSource.setDataSource((String)"mysqlData");
        IposOrderExample example = new IposOrderExample();
        example.createCriteria().andCodeEqualTo(orderCode).andChannelCodeEqualTo(channel);
        List orderList = this.iposOrderMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return ServiceResp.newInstanceFail((String)("\u8ba2\u5355\u4e0d\u5b58\u5728[" + orderCode + "]"));
        }
        IposOrder iposOrder = (IposOrder)orderList.get(0);
        IposOrderLineExample lineExample = new IposOrderLineExample();
        lineExample.createCriteria().andCodeEqualTo(iposOrder.getCode());
        List orderLineList = this.iposOrderLineMapper.selectByExample(lineExample);
        if (CollectionUtils.isEmpty((Collection)orderLineList)) {
            return ServiceResp.newInstanceFail((String)("\u8ba2\u5355\u8ba2\u4e3a\u7a7a[" + orderCode + "]"));
        }
        IposOrderDTO iposOrderDTO = this.buildIposOrder(iposOrder, orderLineList);
        return ServiceResp.newInstanceSuccess((Object)iposOrderDTO);
    }

    private IposOrderDTO buildIposOrder(IposOrder iposOrder, List<IposOrderLine> orderLines) {
        if (iposOrder == null || CollectionUtils.isEmpty(orderLines)) {
            return null;
        }
        IposOrderDTO iposOrderDTO = (IposOrderDTO)BeanUtil.buildFrom((Object)iposOrder, IposOrderDTO.class);
        BigDecimal scale = new BigDecimal(0.01).setScale(2, 1);
        iposOrderDTO.setTotalAmount(BigDecimal.valueOf(iposOrder.getTotalAmount()).multiply(scale));
        iposOrderDTO.setDiscountAmount(BigDecimal.valueOf(iposOrder.getDiscountAmount()).multiply(scale));
        iposOrderDTO.setPaymentAmount(BigDecimal.valueOf(iposOrder.getPaymentAmount()).multiply(scale));
        Integer quantity = 0;
        for (IposOrderLine orderLine : orderLines) {
            IposOrderLineDTO iposOrderLine = (IposOrderLineDTO)BeanUtil.buildFrom((Object)orderLine, IposOrderLineDTO.class);
            iposOrderLine.setDiscountAmount(BigDecimal.valueOf(orderLine.getDiscountAmount()).multiply(scale));
            iposOrderLine.setPaymentAmount(BigDecimal.valueOf(orderLine.getPaymentAmount()).multiply(scale));
            iposOrderLine.setTotalAmount(BigDecimal.valueOf(orderLine.getTotalAmount()).multiply(scale));
            if (iposOrderLine.getType() == 1 && iposOrderLine.getItemQty() == 0) {
                iposOrderLine.setItemQty(Integer.valueOf(-1));
            }
            iposOrderDTO.getIposOrderLineList().add(iposOrderLine);
            quantity = quantity + iposOrderLine.getItemQty();
        }
        iposOrderDTO.setItemQty(quantity);
        return iposOrderDTO;
    }
}

