/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.bi.dao.ApiDataStockInfMapper;
import com.thebeastshop.bi.dto.ApiDataStockInfDTO;
import com.thebeastshop.bi.dto.ApiSkuSearchForHomeCondDTO;
import com.thebeastshop.bi.service.BiSkuStockService;
import com.thebeastshop.bi.vo.BiSkuStockVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="biSkuStockService")
public class BiSkuStockServiceImpl
implements BiSkuStockService {
    @Autowired
    private ApiDataStockInfMapper apiDataStockInfMapper;

    public List<BiSkuStockVO> findSkuStockForHomeByCond(ApiSkuSearchForHomeCondDTO condDTO) {
        List apiDataStockInfList = this.apiDataStockInfMapper.searchSkuStockByCond(condDTO);
        for (BiSkuStockVO biSkuStockVO : apiDataStockInfList) {
            ArrayList dtoList = Lists.newArrayList();
            String[] warehouseCodes = this.toStringList(biSkuStockVO.getWarehouseCodes());
            String[] warehouseNames = this.toStringList(biSkuStockVO.getWarehouseNames());
            String[] invs = this.toStringList(biSkuStockVO.getCanUseInvs());
            Integer i = 0;
            while (i < warehouseCodes.length) {
                ApiDataStockInfDTO apiDataStockInfDTO = new ApiDataStockInfDTO();
                apiDataStockInfDTO.setSkuCode(biSkuStockVO.getSkuCode());
                apiDataStockInfDTO.setWarehouseCode(warehouseCodes[i]);
                apiDataStockInfDTO.setWarehouseName(warehouseNames[i]);
                apiDataStockInfDTO.setQuantity(Integer.valueOf(Integer.parseInt(invs[i].replace("\"", ""))));
                dtoList.add(apiDataStockInfDTO);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            biSkuStockVO.setApiDataStockInfDTOS((List)dtoList);
        }
        return apiDataStockInfList;
    }

    public Integer countSkuStockForHomeByCond(ApiSkuSearchForHomeCondDTO condDTO) {
        return this.apiDataStockInfMapper.countSkuStockByCond(condDTO);
    }

    private String[] toStringList(String str) {
        str = str.replace("{", "");
        str = str.replace("}", "");
        str = str.replace("\"", "");
        return str.split(",");
    }
}

