/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.github.pagehelper.util.StringUtil;
import com.thebeastshop.bi.dao.OpMemberLabelBasicMapper;
import com.thebeastshop.bi.dao.OpMemberLabelBasicMultipleMapper;
import com.thebeastshop.bi.dao.OpMemberLabelBehaviourChannelMapper;
import com.thebeastshop.bi.dao.OpMemberLabelBehaviourMapper;
import com.thebeastshop.bi.dao.OpMemberLabelConsumeMapper;
import com.thebeastshop.bi.dao.OpMemberLabelConsumeMultipleMapper;
import com.thebeastshop.bi.dao.OpMemberLabelMapper;
import com.thebeastshop.bi.dto.OpMemberLabelQueryDTO;
import com.thebeastshop.bi.po.OpMemberLabel;
import com.thebeastshop.bi.po.OpMemberLabelBasic;
import com.thebeastshop.bi.po.OpMemberLabelBasicMultiple;
import com.thebeastshop.bi.po.OpMemberLabelBehaviour;
import com.thebeastshop.bi.po.OpMemberLabelBehaviourChannel;
import com.thebeastshop.bi.po.OpMemberLabelConsume;
import com.thebeastshop.bi.po.OpMemberLabelConsumeMultiple;
import com.thebeastshop.bi.po.OpMemberLabelExample;
import com.thebeastshop.bi.service.OpMemberLabelService;
import com.thebeastshop.bi.vo.OpMemberLabelBasicMultipleVO;
import com.thebeastshop.bi.vo.OpMemberLabelBasicVO;
import com.thebeastshop.bi.vo.OpMemberLabelBehaviourChannelVO;
import com.thebeastshop.bi.vo.OpMemberLabelBehaviourVO;
import com.thebeastshop.bi.vo.OpMemberLabelConsumeMultipleVO;
import com.thebeastshop.bi.vo.OpMemberLabelConsumeVO;
import com.thebeastshop.bi.vo.OpMemberLabelVO;
import com.thebeastshop.common.Page;
import com.thebeastshop.common.PageQueryResp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="opMemberLabelService")
public class OpMemberLabelServiceImpl
implements OpMemberLabelService {
    @Autowired
    private OpMemberLabelMapper opMemberLabelMapper;
    @Autowired
    private OpMemberLabelBasicMapper opMemberLabelBasicMapper;
    @Autowired
    private OpMemberLabelBasicMultipleMapper opMemberLabelBasicMultipleMapper;
    @Autowired
    private OpMemberLabelBehaviourMapper opMemberLabelBehaviourMapper;
    @Autowired
    private OpMemberLabelBehaviourChannelMapper opMemberLabelBehaviourChannelMapper;
    @Autowired
    private OpMemberLabelConsumeMapper opMemberLabelConsumeMapper;
    @Autowired
    private OpMemberLabelConsumeMultipleMapper opMemberLabelConsumeMultipleMapper;

    public PageQueryResp<OpMemberLabelVO> queryMemberLabelPageByDto(OpMemberLabelQueryDTO dto) {
        PageQueryResp page = new PageQueryResp();
        OpMemberLabelExample example = new OpMemberLabelExample();
        OpMemberLabelExample.Criteria criteria = example.createCriteria();
        this.criteriaDTO(criteria, dto);
        int count = this.opMemberLabelMapper.countByExample(example);
        if (count > 0) {
            example.setPage(new Page(dto.getCurrpage().intValue(), dto.getPagenum().intValue()));
            example.setOrderByClause("create_time desc");
            List labelList = this.opMemberLabelMapper.selectByExample(example);
            page.setBeanList(null);
            page.setPageSize(dto.getPagenum());
            page.setPageNo(dto.getCurrpage());
            page.setTotalCnt(Integer.valueOf(count));
        }
        return page;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public boolean addMemberLabel(OpMemberLabelVO labelVo) throws Exception {
        if (labelVo == null) throw new Exception("\u65b0\u589e\u6570\u636e\u4e3a\u7a7a");
        String labelName = labelVo.getName();
        if (StringUtils.isEmpty((String)labelName)) {
            throw new Exception("\u6807\u7b7e\u540d\u79f0\u4e3a\u7a7a");
        }
        OpMemberLabel label = new OpMemberLabel();
        label.setName(labelName);
        label.setCreateOperatorId(labelVo.getCreateOperatorId());
        label.setCreateOperatorName(labelVo.getCreateOperatorName());
        label.setCreateTime(new Date());
        if (this.opMemberLabelMapper.insertSelective(label) <= 0) throw new Exception("\u6807\u7b7e\u8868\u65b0\u589e\u5931\u8d25");
        Integer labelId = label.getId();
        if (labelId <= 0) return true;
        if (labelVo.getBasic() != null) {
            OpMemberLabelBasicVO basicVO = labelVo.getBasic();
            OpMemberLabelBasic basic = new OpMemberLabelBasic();
            basic.setLabelId(labelId);
            BeanUtils.copyProperties((Object)basic, (Object)basicVO);
            if (this.opMemberLabelBasicMapper.insertSelective(basic) <= 0) throw new Exception("\u6807\u7b7e-\u57fa\u672c\u5c5e\u6027\u8868\u65b0\u589e\u5931\u8d25");
            Integer basicId = basic.getId();
            List basicMultipleVO = basicVO.getMultipleList();
            if (CollectionUtils.isNotEmpty((Collection)basicMultipleVO)) {
                for (OpMemberLabelBasicMultipleVO mu : basicMultipleVO) {
                    OpMemberLabelBasicMultiple m = new OpMemberLabelBasicMultiple();
                    m.setLabelBasicId(basicId);
                    BeanUtils.copyProperties((Object)m, (Object)mu);
                    this.opMemberLabelBasicMultipleMapper.insert(m);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)labelVo.getBehaviour())) {
            List behaviourList = labelVo.getBehaviour();
            for (OpMemberLabelBehaviourVO be : behaviourList) {
                OpMemberLabelBehaviour behaviour = new OpMemberLabelBehaviour();
                BeanUtils.copyProperties((Object)behaviour, (Object)be);
                behaviour.setLabelId(labelId);
                if (this.opMemberLabelBehaviourMapper.insert(behaviour) <= 0) throw new Exception("\u6807\u7b7e-\u884c\u4e3a\u6570\u636e\u8868\u65b0\u589e\u5931\u8d25");
                Integer behaviourId = behaviour.getId();
                List behaviourChannelList = be.getChannelList();
                if (!CollectionUtils.isNotEmpty((Collection)behaviourChannelList)) continue;
                for (OpMemberLabelBehaviourChannelVO channel : behaviourChannelList) {
                    OpMemberLabelBehaviourChannel chan = new OpMemberLabelBehaviourChannel();
                    chan.setLabelBehaviourId(behaviourId);
                    BeanUtils.copyProperties((Object)chan, (Object)channel);
                    this.opMemberLabelBehaviourChannelMapper.insert(chan);
                }
            }
        }
        if (!CollectionUtils.isNotEmpty((Collection)labelVo.getConsume())) return true;
        List consumeList = labelVo.getConsume();
        for (OpMemberLabelConsumeVO co : consumeList) {
            OpMemberLabelConsume consume = new OpMemberLabelConsume();
            BeanUtils.copyProperties((Object)consume, (Object)co);
            consume.setLabelId(labelId);
            if (this.opMemberLabelConsumeMapper.insert(consume) <= 0) throw new Exception("\u6807\u7b7e-\u6d88\u8d39\u4e60\u60ef\u65b0\u589e\u5931\u8d25");
            Integer consumeId = consume.getId();
            List multipleList = co.getMultipleList();
            if (!CollectionUtils.isNotEmpty((Collection)multipleList)) continue;
            for (OpMemberLabelConsumeMultipleVO mu : multipleList) {
                OpMemberLabelConsumeMultiple multiple = new OpMemberLabelConsumeMultiple();
                multiple.setLabelConsumeId(consumeId);
                BeanUtils.copyProperties((Object)multiple, (Object)mu);
                this.opMemberLabelConsumeMultipleMapper.insertSelective(multiple);
            }
        }
        return true;
    }

    public boolean updateMemberLabel(OpMemberLabelVO vo) {
        return false;
    }

    private void criteriaDTO(OpMemberLabelExample.Criteria criteria, OpMemberLabelQueryDTO dto) {
        if (dto.getId() != null) {
            criteria.andIdEqualTo(dto.getId());
        }
        if (!StringUtil.isEmpty((String)dto.getName())) {
            criteria.andNameEqualTo(dto.getName());
        }
        if (dto.getCreateOperateId() != null) {
            criteria.andCreateOperatorIdEqualTo(dto.getCreateOperateId());
        }
        if (!StringUtil.isEmpty((String)dto.getCreateOperateName())) {
            criteria.andCreateOperatorNameEqualTo(dto.getCreateOperateName());
        }
    }
}

