/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberHelper {
    private static final BigInteger INT_MAX = new BigInteger("2147483647");
    private static final BigInteger INT_MIN = new BigInteger("-2147483648");
    private static final BigInteger LONG_MAX = new BigInteger("9223372036854775807");
    private static final BigInteger LONG_MIN = new BigInteger("-9223372036854775808");
    private static final NumberOperator ADD_OPERATOR = new NumberOperator(){

        @Override
        public Integer doOperate(Byte n1, Byte n2) {
            return n1 + n2;
        }

        @Override
        public Integer doOperate(Short n1, Short n2) {
            return n1 + n2;
        }

        @Override
        public Integer doOperate(Integer n1, Integer n2) {
            return n1 + n2;
        }

        @Override
        public Long doOperate(Long n1, Long n2) {
            return n1 + n2;
        }

        @Override
        public BigInteger doOperate(BigInteger n1, BigInteger n2) {
            return n1.add(n2);
        }

        @Override
        public BigDecimal doOperate(BigDecimal n1, BigDecimal n2) {
            return n1.add(n2);
        }
    };
    private static final NumberOperator SUB_OPERATOR = new NumberOperator(){

        @Override
        public Integer doOperate(Byte n1, Byte n2) {
            return n1 - n2;
        }

        @Override
        public Integer doOperate(Short n1, Short n2) {
            return n1 - n2;
        }

        @Override
        public Integer doOperate(Integer n1, Integer n2) {
            return n1 - n2;
        }

        @Override
        public Long doOperate(Long n1, Long n2) {
            return n1 + n2;
        }

        @Override
        public BigInteger doOperate(BigInteger n1, BigInteger n2) {
            return n1.subtract(n2);
        }

        @Override
        public BigDecimal doOperate(BigDecimal n1, BigDecimal n2) {
            return n1.subtract(n2);
        }
    };
    private static final NumberOperator MULTI_OPERATOR = new NumberOperator(){

        @Override
        public Integer doOperate(Byte n1, Byte n2) {
            return n1 * n2;
        }

        @Override
        public Integer doOperate(Short n1, Short n2) {
            return n1 * n2;
        }

        @Override
        public Integer doOperate(Integer n1, Integer n2) {
            return n1 * n2;
        }

        @Override
        public Long doOperate(Long n1, Long n2) {
            return n1 * n2;
        }

        @Override
        public BigInteger doOperate(BigInteger n1, BigInteger n2) {
            return n1.multiply(n2);
        }

        @Override
        public BigDecimal doOperate(BigDecimal n1, BigDecimal n2) {
            return n1.multiply(n2);
        }
    };
    private static final NumberOperator DIV_OPERATOR = new NumberOperator(){

        @Override
        public Integer doOperate(Byte n1, Byte n2) {
            return n1 / n2;
        }

        @Override
        public Integer doOperate(Short n1, Short n2) {
            return n1 / n2;
        }

        @Override
        public Integer doOperate(Integer n1, Integer n2) {
            return n1 / n2;
        }

        @Override
        public Long doOperate(Long n1, Long n2) {
            return n1 / n2;
        }

        @Override
        public BigInteger doOperate(BigInteger n1, BigInteger n2) {
            return n1.divide(n2);
        }

        @Override
        public BigDecimal doOperate(BigDecimal n1, BigDecimal n2) {
            return n1.divide(n2);
        }
    };
    private static final NumberOperator POWER_OPERATOR = new NumberOperator(){

        @Override
        public Integer doOperate(Byte n1, Byte n2) {
            return new BigInteger(n1 + "").pow(n2.byteValue()).intValue();
        }

        @Override
        public Integer doOperate(Short n1, Short n2) {
            return new BigInteger(n1 + "").pow(n2.shortValue()).intValue();
        }

        @Override
        public Integer doOperate(Integer n1, Integer n2) {
            return new BigInteger(n1 + "").pow(n2).intValue();
        }

        @Override
        public Long doOperate(Long n1, Long n2) {
            return new BigInteger(n1 + "").pow(n2.intValue()).longValue();
        }

        @Override
        public BigInteger doOperate(BigInteger n1, BigInteger n2) {
            return n1.pow(n2.intValue());
        }

        @Override
        public BigDecimal doOperate(BigDecimal n1, BigDecimal n2) {
            return n1.pow(n2.intValue());
        }
    };

    public static Number parseIntegerNumber(String text) {
        BigInteger value = new BigInteger(text);
        if (value.compareTo(INT_MIN) > 0 && value.compareTo(INT_MAX) < 0) {
            return value.intValue();
        }
        if (value.compareTo(LONG_MIN) > 0 && value.compareTo(LONG_MAX) < 0) {
            return value.longValue();
        }
        return value;
    }

    public static Number castNumber(Class targetType, Number number) {
        Class<?> numClass = number.getClass();
        if (targetType == numClass) {
            return number;
        }
        if (targetType == Byte.class) {
            return number.byteValue();
        }
        if (targetType == Short.class) {
            return number.shortValue();
        }
        if (targetType == Integer.class) {
            return number.intValue();
        }
        if (targetType == Long.class) {
            return number.longValue();
        }
        if (targetType == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (targetType == Double.class) {
            return number.doubleValue();
        }
        if (targetType == BigInteger.class) {
            return BigInteger.valueOf(number.longValue());
        }
        if (targetType == BigDecimal.class) {
            return new BigDecimal(number + "");
        }
        throw new ClassCastException(number + " can not be casted to " + targetType.getName());
    }

    public static int compare(Number number1, Number number2) {
        if (number1 == number2) {
            return 0;
        }
        if (number1.equals(number2)) {
            return 0;
        }
        if ((number1 instanceof Byte || number1 instanceof Short || number1 instanceof Integer || number1 instanceof Long) && (number2 instanceof Byte || number2 instanceof Short || number2 instanceof Integer || number2 instanceof Long)) {
            long l2;
            long l1 = number1.longValue();
            return l1 > (l2 = number2.longValue()) ? 1 : (l1 == l2 ? 0 : -1);
        }
        if ((number1 instanceof Float || number1 instanceof Double) && (number2 instanceof Float || number2 instanceof Double)) {
            double d2;
            double d1 = number1.doubleValue();
            return d1 > (d2 = number2.doubleValue()) ? 1 : (d1 == d2 ? 0 : -1);
        }
        if (number1 instanceof BigInteger && number2 instanceof BigInteger) {
            return ((BigInteger)number1).compareTo((BigInteger)number2);
        }
        if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
            return ((BigDecimal)number1).compareTo((BigDecimal)number2);
        }
        BigDecimal bd1 = new BigDecimal(number1.toString());
        BigDecimal bd2 = new BigDecimal(number2.toString());
        return bd1.compareTo(bd2);
    }

    private static Number operate(Number number1, Number number2, NumberOperator operator) {
        if (number1 instanceof Byte && number2 instanceof Byte) {
            return operator.doOperate((Byte)number1, number2.byteValue());
        }
        if (number1 instanceof Short && (number2 instanceof Byte || number2 instanceof Short)) {
            return operator.doOperate((Short)number1, number2.shortValue());
        }
        if (number1 instanceof Integer && (number2 instanceof Byte || number2 instanceof Short || number2 instanceof Integer)) {
            return operator.doOperate((Integer)number1, number2.intValue());
        }
        if (number1 instanceof Long && (number2 instanceof Byte || number2 instanceof Short || number2 instanceof Integer)) {
            return operator.doOperate(number1.longValue(), number2.longValue());
        }
        if (number1 instanceof BigInteger && number2 instanceof BigInteger) {
            return operator.doOperate((BigInteger)number1, (BigInteger)number2);
        }
        if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
            return operator.doOperate((BigDecimal)number1, (BigDecimal)number2);
        }
        return operator.doOperate(new BigDecimal(number1 + ""), new BigDecimal(number2 + ""));
    }

    public static Number add(Number number1, Number number2) {
        return NumberHelper.operate(number1, number2, ADD_OPERATOR);
    }

    public static Number sub(Number number1, Number number2) {
        return NumberHelper.operate(number1, number2, SUB_OPERATOR);
    }

    public static Number multi(Number number1, Number number2) {
        return NumberHelper.operate(number1, number2, MULTI_OPERATOR);
    }

    public static Number div(Number number1, Number number2) {
        return NumberHelper.operate(number1, number2, DIV_OPERATOR);
    }

    public static Number power(Number number1, Number number2) {
        return NumberHelper.operate(number1, number2, POWER_OPERATOR);
    }

    private static interface NumberOperator {
        public Integer doOperate(Byte var1, Byte var2);

        public Integer doOperate(Short var1, Short var2);

        public Integer doOperate(Integer var1, Integer var2);

        public Long doOperate(Long var1, Long var2);

        public BigInteger doOperate(BigInteger var1, BigInteger var2);

        public BigDecimal doOperate(BigDecimal var1, BigDecimal var2);
    }
}

