/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.runtime.wrapper.BooleanWrapper;
import com.thebeastshop.bgel.utils.MetaHelper;
import org.antlr.v4.runtime.Token;

public class BooleanEvaluator {
    public Boolean evaluate(BgelRuntimeContext context, ASTBinaryExpression node, Object left, Object right) {
        left = MetaHelper.wrap(left);
        right = MetaHelper.wrap(right);
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        Token op = node.getOperation();
        if (!(left instanceof BooleanWrapper)) {
            throw new BgelEvalException(context, node, "operator \"" + op.getText() + "\" do not support for type " + leftClass);
        }
        if (!(right instanceof BooleanWrapper)) {
            throw new BgelEvalException(context, node, "operator \"" + op.getText() + "\" do not support for type " + rightClass);
        }
        switch (op.getType()) {
            case 19: 
            case 21: {
                return ((BooleanWrapper)left).and((BooleanWrapper)right);
            }
            case 20: 
            case 22: {
                return ((BooleanWrapper)left).or((BooleanWrapper)right);
            }
        }
        throw new BgelEvalException(context, node, "operator \"" + op.getText() + "\" do not support for type " + leftClass + " and " + rightClass);
    }
}

