/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.runtime.MetaMethod;
import com.thebeastshop.bgel.runtime.MethodParameterTypes;
import java.util.LinkedList;
import java.util.List;

public class SameNameMethodCollection {
    private final String methodName;
    private List<MetaMethod> methods = new LinkedList<MetaMethod>();

    public SameNameMethodCollection(String methodName) {
        this.methodName = methodName;
    }

    public void addMethod(MetaMethod method) {
        this.methods.add(method);
    }

    public MetaMethod getSameParamTypesMethod(Class[] paramTypes) {
        for (MetaMethod metaMethod : this.methods) {
            if (!metaMethod.getParamTypes().equalsTypes(paramTypes)) continue;
            return metaMethod;
        }
        return null;
    }

    public MetaMethod chooseMethod(Class clazz, Object[] arguments) {
        int methodLen = this.methods.size();
        if (methodLen == 0) {
            return null;
        }
        if (methodLen == 1) {
            return this.methods.get(0);
        }
        MetaMethod ret = null;
        long matchingDistance = -1L;
        LinkedList<MetaMethod> ambiguousMethods = new LinkedList<MetaMethod>();
        for (MetaMethod metaMethod : this.methods) {
            MethodParameterTypes parameterTypes = metaMethod.getParamTypes();
            if (!parameterTypes.isValidArguments(arguments)) continue;
            long distance = parameterTypes.calculateDistanceWithArguments(arguments);
            if (distance == 0L) {
                return metaMethod;
            }
            if (ret == null || distance < matchingDistance) {
                ret = metaMethod;
                matchingDistance = distance;
                ambiguousMethods.clear();
                continue;
            }
            if (distance != matchingDistance) continue;
            if (ambiguousMethods.isEmpty()) {
                ambiguousMethods.add(ret);
            }
            ambiguousMethods.add(metaMethod);
        }
        if (!ambiguousMethods.isEmpty()) {
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("Ambiguous method ").append("\"").append(clazz.getName());
            msgBuilder.append(".").append(this.methodName).append("\"\n");
            for (MetaMethod method : ambiguousMethods) {
                msgBuilder.append("\n");
                msgBuilder.append("                  ");
                msgBuilder.append(clazz.getName());
                msgBuilder.append('.');
                msgBuilder.append(method.getMethodDeclarationName());
            }
            throw new RuntimeException(msgBuilder.toString());
        }
        return ret;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

