/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.ast;

import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTVisitor;
import com.thebeastshop.bgel.runtime.BgelDate;
import com.thebeastshop.bgel.runtime.BgelRange;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.runtime.BgelTimeDuration;
import com.thebeastshop.bgel.utils.TypeHelper;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class ASTType
extends ASTExpression {
    public static final ASTType UNDEFINED = new ASTType("Undefined");
    public static final ASTType TYPE;
    public static final ASTType OBJECT;
    public static final ASTType BOOLEAN;
    public static final ASTType INTEGER;
    public static final ASTType NUMERIC;
    public static final ASTType STRING;
    public static final ASTType RANGE;
    public static final ASTType LIST;
    public static final ASTType MAP;
    public static final ASTType MAP_ENTRY;
    public static final ASTType DATE;
    public static final ASTType TIME_DURATION;
    private final String importedName;
    private Class clazz;
    private boolean isUndefined = false;

    public static ASTType fromJavaClass(Class cls) {
        if (TypeHelper.isInteger(cls)) {
            return INTEGER;
        }
        if (TypeHelper.isNumeric(cls)) {
            return NUMERIC;
        }
        if (TypeHelper.isString(cls)) {
            return STRING;
        }
        if (TypeHelper.isBoolean(cls)) {
            return BOOLEAN;
        }
        return OBJECT;
    }

    public ASTType(String importedName, Class clazz) {
        super(TYPE);
        this.importedName = importedName;
        this.clazz = clazz;
    }

    public ASTType(String importedName) {
        super(TYPE);
        this.importedName = importedName;
    }

    public String getImportedName() {
        return this.importedName;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public boolean isUndefined() {
        return this.isUndefined;
    }

    public void setUndefined(boolean undefined) {
        this.isUndefined = undefined;
    }

    @Override
    public void visit(BgelRuntimeContext context, ASTVisitor visitor) {
        visitor.visitType(context, this);
    }

    @Override
    public String getText() {
        return this.getImportedName();
    }

    static {
        UNDEFINED.setUndefined(true);
        TYPE = new ASTType("Type", Type.class);
        OBJECT = new ASTType("Object", Object.class);
        BOOLEAN = new ASTType("Boolean", Boolean.class);
        INTEGER = new ASTType("Integer", Integer.class);
        NUMERIC = new ASTType("Numeric", BigDecimal.class);
        STRING = new ASTType("String", String.class);
        RANGE = new ASTType("Range", BgelRange.class);
        LIST = new ASTType("List", List.class);
        MAP = new ASTType("Map", Map.class);
        MAP_ENTRY = new ASTType("MapEntry", Map.Entry.class);
        DATE = new ASTType("Date", BgelDate.class);
        TIME_DURATION = new ASTType("Date", BgelTimeDuration.class);
    }
}

