/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AccessUtils {
    private static String getPrefixName(String prefix, String accessName) {
        if (accessName == null || accessName.length() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(accessName.substring(0, 1).toUpperCase());
        if (accessName.length() > 1) {
            builder.append(accessName.substring(1, accessName.length()));
        }
        return builder.toString();
    }

    public static String getGetterName(String accessName) {
        return AccessUtils.getPrefixName("get", accessName);
    }

    public static String getSetterName(String accessName) {
        return AccessUtils.getPrefixName("set", accessName);
    }

    public static Method getNoneParametersMethod(Class clazz, String methodName) throws NoSuchMethodException {
        return clazz.getMethod(methodName, new Class[0]);
    }

    public static Object getNoneParamtersMethodValue(Object obj, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = AccessUtils.getNoneParametersMethod(obj.getClass(), methodName);
        return method.invoke(obj, new Object[0]);
    }

    public static Method getGetterMethodByAccessName(Class clazz, String accessName) throws NoSuchMethodException {
        return AccessUtils.getNoneParametersMethod(clazz, AccessUtils.getGetterName(accessName));
    }

    public static Object getGetterValue(Object obj, String accessName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getterMethod = AccessUtils.getGetterMethodByAccessName(obj.getClass(), accessName);
        return getterMethod.invoke(obj, new Object[0]);
    }

    public static Field getFieldByAccessName(Class clazz, String accessName) throws NoSuchFieldException {
        return clazz.getField(accessName);
    }

    public static Object getFieldValue(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = AccessUtils.getFieldByAccessName(obj.getClass(), fieldName);
        return field.get(obj);
    }

    public static Object accessObject(Object obj, String accessName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            return AccessUtils.getFieldValue(obj, accessName);
        }
        catch (NoSuchFieldException e) {
            try {
                return AccessUtils.getNoneParamtersMethodValue(obj, accessName);
            }
            catch (NoSuchMethodException e1) {
                return AccessUtils.getGetterValue(obj, accessName);
            }
            catch (InvocationTargetException e1) {
                throw e1;
            }
        }
        catch (IllegalAccessException e) {
            throw e;
        }
    }
}

