/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.transform;

import com.thebeastshop.bgel.ast.ASTConstant;
import com.thebeastshop.bgel.ast.ASTDate;
import com.thebeastshop.bgel.ast.ASTNode;
import com.thebeastshop.bgel.ast.BgelType;
import com.thebeastshop.bgel.transform.ExpressionTransformer;
import org.antlr.v4.runtime.Token;

public class DateTransformer
extends ExpressionTransformer {
    public ASTDate transform(Token yyyyMMddToken, Token timeToken, Token startToken, Token endToken) {
        String yyyyMMdd = yyyyMMddToken.getText();
        String time = null;
        if (timeToken != null) {
            time = timeToken.getText();
        }
        String year = yyyyMMdd.substring(0, 4);
        String month = yyyyMMdd.substring(5, 7);
        String day = yyyyMMdd.substring(8, 10);
        ASTConstant yearExpr = new ASTConstant(Integer.parseInt(year), BgelType.INTEGER);
        ASTConstant monthExpr = new ASTConstant(Integer.parseInt(month), BgelType.INTEGER);
        ASTConstant dayExpr = new ASTConstant(Integer.parseInt(day), BgelType.INTEGER);
        this.setPosition(yearExpr, startToken.getLine(), startToken.getLine(), startToken.getStartIndex(), startToken.getStartIndex() + 3);
        this.setPosition(monthExpr, startToken.getLine(), startToken.getLine(), startToken.getStartIndex() + 5, startToken.getStartIndex() + 6);
        this.setPosition(monthExpr, startToken.getLine(), startToken.getLine(), startToken.getStartIndex() + 8, startToken.getStartIndex() + 9);
        ASTDate date = new ASTDate();
        date.setYear(yearExpr);
        date.setMonth(monthExpr);
        date.setDay(dayExpr);
        if (time != null) {
            String[] timeArgs = time.split(":");
            String hh = timeArgs[0];
            String mm = timeArgs[1];
            Integer hours = Integer.parseInt(hh);
            Integer minutes = Integer.parseInt(mm);
            Integer seconds = null;
            Integer milliseconds = null;
            ASTConstant hoursExpr = new ASTConstant(hours, BgelType.INTEGER);
            ASTConstant minutesExpr = new ASTConstant(minutes, BgelType.INTEGER);
            this.setPosition(hoursExpr, timeToken.getLine(), timeToken.getLine(), timeToken.getStartIndex(), timeToken.getStartIndex() + 1);
            this.setPosition(minutesExpr, timeToken.getLine(), timeToken.getLine(), timeToken.getStartIndex() + 3, timeToken.getStartIndex() + 4);
            date.setHours(hoursExpr);
            date.setMinutes(minutesExpr);
            if (timeArgs.length > 2) {
                String ss = timeArgs[2];
                seconds = Integer.parseInt(ss);
                ASTConstant secondsExpr = new ASTConstant(seconds, BgelType.INTEGER);
                this.setPosition(secondsExpr, timeToken.getLine(), timeToken.getLine(), timeToken.getStartIndex() + 6, timeToken.getStartIndex() + 7);
                date.setSeconds(secondsExpr);
                if (timeArgs.length > 3) {
                    String SS = timeArgs[3];
                    milliseconds = Integer.parseInt(SS);
                    ASTConstant millisecondsExpr = new ASTConstant(milliseconds, BgelType.INTEGER);
                    this.setPosition(millisecondsExpr, timeToken.getLine(), timeToken.getLine(), timeToken.getStartIndex() + 10, timeToken.getStartIndex() + 11);
                    date.setMilliseconds(millisecondsExpr);
                }
            }
        }
        this.setPosition((ASTNode)date, startToken, endToken);
        this.printNode(date);
        return date;
    }
}

