/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelDate;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.runtime.BgelTimeDuration;
import com.thebeastshop.bgel.utils.TypeHelper;
import java.math.BigDecimal;
import java.util.Date;

public class SubEvaluator {
    public Object evaluate(BgelRuntimeContext context, ASTBinaryExpression node, Object left, Object right) {
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        if (TypeHelper.isInteger(leftClass) || TypeHelper.isNumeric(leftClass)) {
            BigDecimal leftNum = left instanceof BigDecimal ? (BigDecimal)left : new BigDecimal(left + "");
            if (TypeHelper.isInteger(rightClass) || TypeHelper.isNumeric(rightClass)) {
                BigDecimal rightNum = right instanceof BigDecimal ? (BigDecimal)right : new BigDecimal(right + "");
                return leftNum.subtract(rightNum);
            }
        }
        if (TypeHelper.isDate(leftClass)) {
            BgelDate leftDate = left instanceof BgelDate ? (BgelDate)left : new BgelDate((Date)left);
            if (TypeHelper.isDate(rightClass)) {
                BgelDate rightDate = right instanceof BgelDate ? (BgelDate)right : new BgelDate((Date)right);
                return leftDate.substract(rightDate);
            }
            if (TypeHelper.isTimeDuration(rightClass)) {
                return leftDate.substract((BgelTimeDuration)right);
            }
        }
        if (TypeHelper.isTimeDuration(leftClass)) {
            BgelTimeDuration leftDuration = (BgelTimeDuration)left;
            if (TypeHelper.isTimeDuration(rightClass)) {
                BgelTimeDuration rightDuration = (BgelTimeDuration)right;
                return leftDuration.substract(rightDuration);
            }
        }
        throw new BgelEvalException(context, node, "operator '-' do not support for type " + leftClass + " and " + rightClass);
    }
}

