/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.runtime.BgelTimeDuration;
import com.thebeastshop.bgel.utils.TypeHelper;
import java.math.BigDecimal;

public class MultiplyEvaluator {
    public Object evaluate(BgelRuntimeContext context, ASTBinaryExpression node, Object left, Object right) {
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        if (TypeHelper.isInteger(leftClass) || TypeHelper.isNumeric(leftClass)) {
            BigDecimal leftNum = left instanceof BigDecimal ? (BigDecimal)left : new BigDecimal(left + "");
            if (TypeHelper.isInteger(rightClass) || TypeHelper.isNumeric(rightClass)) {
                BigDecimal rightNum = right instanceof BigDecimal ? (BigDecimal)right : new BigDecimal(right + "");
                return leftNum.multiply(rightNum);
            }
        }
        if (TypeHelper.isTimeDuration(leftClass)) {
            BgelTimeDuration leftDuration = (BgelTimeDuration)left;
            if (TypeHelper.isInteger(rightClass)) {
                BigDecimal rightNum = right instanceof BigDecimal ? (BigDecimal)right : new BigDecimal(right + "");
                return leftDuration.multiply(rightNum.intValue());
            }
        }
        throw new BgelEvalException(context, node, "operator '*' do not support for type " + leftClass + " and " + rightClass);
    }
}

