/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTIdentifier;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelDate;
import com.thebeastshop.bgel.runtime.BgelObject;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.utils.TypeHelper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class IdentifierEvaluator {
    public Object evaluate(BgelRuntimeContext context, ASTIdentifier identifier) {
        String idName;
        Map<String, Object> env = context.getEnv();
        Object ret = env.get(idName = identifier.getName());
        if (ret == null) {
            throw new BgelEvalException(context, identifier, "No such variable named '" + idName + "' is defined");
        }
        if (ret instanceof BgelObject || ret instanceof BigDecimal) {
            return ret;
        }
        Class<?> clazz = ret.getClass();
        if (TypeHelper.isJavaInteger(clazz)) {
            BigDecimal num = new BigDecimal((Integer)ret);
            env.put(idName, num);
            return num;
        }
        if (TypeHelper.isJavaLong(clazz)) {
            BigDecimal num = new BigDecimal((Long)ret);
            env.put(idName, num);
            return num;
        }
        if (TypeHelper.isInteger(clazz) || TypeHelper.isNumeric(clazz)) {
            BigDecimal num = new BigDecimal(ret.toString());
            env.put(idName, num);
            return num;
        }
        if (ret instanceof Date) {
            BgelDate date = new BgelDate((Date)ret);
            env.put(idName, date);
            return date;
        }
        return ret;
    }
}

