/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import org.antlr.v4.runtime.Token;

public class CompareEvaluator {
    public Boolean evaluate(BgelRuntimeContext context, ASTBinaryExpression node, Object left, Object right) {
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        Token op = node.getOperation();
        if (!(left instanceof Comparable)) {
            throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + leftClass);
        }
        if (!(right instanceof Comparable)) {
            throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + rightClass);
        }
        Comparable leftCom = (Comparable)left;
        Comparable rightCom = (Comparable)right;
        switch (op.getType()) {
            case 9: {
                return leftCom.compareTo(rightCom) > 0;
            }
            case 13: {
                return leftCom.compareTo(rightCom) >= 0;
            }
            case 10: {
                return leftCom.compareTo(rightCom) < 0;
            }
            case 14: {
                return leftCom.compareTo(rightCom) <= 0;
            }
            case 15: {
                return leftCom.compareTo(rightCom) == 0;
            }
            case 16: {
                return leftCom.compareTo(rightCom) != 0;
            }
        }
        throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + leftClass + " and " + rightClass);
    }
}

