/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import org.antlr.v4.runtime.Token;

public class BooleanEvaluator {
    public Boolean evaluate(BgelRuntimeContext context, ASTBinaryExpression node, Object left, Object right) {
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        Token op = node.getOperation();
        if (!(left instanceof Boolean)) {
            throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + leftClass);
        }
        if (!(right instanceof Boolean)) {
            throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + rightClass);
        }
        Boolean leftBool = (Boolean)left;
        Boolean rightBool = (Boolean)right;
        switch (op.getType()) {
            case 19: 
            case 21: {
                return leftBool != false && rightBool != false;
            }
            case 20: 
            case 22: {
                return leftBool != false || rightBool != false;
            }
        }
        throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + leftClass + " and " + rightClass);
    }
}

