/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.runtime.BgelObject;
import com.thebeastshop.bgel.utils.TypeHelper;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class BgelTimeDuration
extends BgelObject
implements Comparable {
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final int DAY = 86400000;
    private long milisecond;

    public BgelTimeDuration(int hour, int minute, int second) {
        this(0, hour, minute, second);
    }

    public BgelTimeDuration(int day, int hour, int minute, int second) {
        this(day * 86400000 + second * 1000 + minute * 60000 + hour * 3600000);
    }

    public BgelTimeDuration(int day, int hour, int minute, int second, int millisecond) {
        this(day * 86400000 + second * 1000 + minute * 60000 + hour * 3600000 + millisecond);
    }

    public BgelTimeDuration(long milisecond) {
        this.setMilisecond(milisecond);
    }

    private int getCalendarValue(int t) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(14, (int)Math.abs(this.milisecond));
        return calendar.get(t);
    }

    private void setCalendarValue(int t, int v) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(14, (int)Math.abs(this.milisecond));
        calendar.set(t, v);
        this.milisecond = (this.milisecond < 0L ? -1 : 1) * calendar.get(14);
    }

    public int toDay() {
        return (int)Math.floor(this.milisecond / 86400000L);
    }

    public int toHour() {
        return (int)Math.floor(this.milisecond / 3600000L);
    }

    public int toMinute() {
        return (int)Math.floor(this.milisecond / 60000L);
    }

    public int toSecond() {
        return (int)Math.floor(this.milisecond / 1000L);
    }

    public int getHour() {
        return this.getCalendarValue(10);
    }

    public void setHour(int hour) {
        this.setCalendarValue(11, hour);
    }

    public int getMinute() {
        return this.getCalendarValue(12);
    }

    public void setMinute(int minute) {
        this.setCalendarValue(12, minute);
    }

    public int getSecond() {
        return this.getCalendarValue(13);
    }

    public void setSecond(int second) {
        this.setCalendarValue(13, second);
    }

    public long getMilisecond() {
        return this.milisecond;
    }

    public void setMilisecond(long milisecond) {
        this.milisecond = milisecond;
    }

    public BgelTimeDuration add(BgelTimeDuration timeDuration) {
        long newMilisecond = this.getMilisecond() + timeDuration.getMilisecond();
        return new BgelTimeDuration(newMilisecond);
    }

    public BgelTimeDuration substract(BgelTimeDuration timeDuration) {
        long tmilisecond = timeDuration.getMilisecond();
        long newMilisecond = this.milisecond - tmilisecond;
        return new BgelTimeDuration(newMilisecond);
    }

    public BgelTimeDuration multiply(int i) {
        long newMilisecond = this.milisecond * (long)i;
        return new BgelTimeDuration(newMilisecond);
    }

    public BgelTimeDuration multiply(float f) {
        long newMilisecond = (long)((float)this.milisecond * f);
        return new BgelTimeDuration(newMilisecond);
    }

    public BgelTimeDuration multiply(BigDecimal d) {
        long newMilisecond = this.milisecond * d.longValue();
        return new BgelTimeDuration(newMilisecond);
    }

    public BgelTimeDuration divide(int i) {
        long newMilisecond = this.milisecond / (long)i;
        return new BgelTimeDuration(newMilisecond);
    }

    public BgelTimeDuration divide(float f) {
        long newMilisecond = (long)((float)this.milisecond / f);
        return new BgelTimeDuration(newMilisecond);
    }

    public BgelTimeDuration divide(BigDecimal d) {
        long newMilisecond = this.milisecond / d.longValue();
        return new BgelTimeDuration(newMilisecond);
    }

    public BigDecimal divide(BgelTimeDuration duration) {
        return new BigDecimal(this.milisecond).divide(new BigDecimal(duration.getMilisecond()));
    }

    public Date toDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(14, (int)this.milisecond);
        return calendar.getTime();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BgelTimeDuration) {
            return this.milisecond == ((BgelTimeDuration)obj).getMilisecond();
        }
        if (obj instanceof Integer) {
            return this.milisecond == (long)((Integer)obj).intValue();
        }
        if (obj instanceof Long) {
            return this.milisecond == (Long)obj;
        }
        if (obj instanceof BigDecimal) {
            return this.milisecond == (long)((BigDecimal)obj).intValue();
        }
        return false;
    }

    public String toString() {
        int hour = this.toHour();
        int minute = this.getMinute();
        int second = this.getSecond();
        StringBuffer buffer = new StringBuffer();
        if (this.milisecond < 0L) {
            buffer.append('-');
        }
        buffer.append(Math.abs(hour));
        buffer.append(':');
        if (minute < 10) {
            buffer.append(0);
        }
        buffer.append(minute);
        if (second > 0) {
            buffer.append(':');
            if (second < 10) {
                buffer.append(0);
            }
            buffer.append(second);
        }
        return buffer.toString();
    }

    public int compareTo(Object o) {
        if (TypeHelper.isTimeDuration(o.getClass())) {
            BgelTimeDuration duration = (BgelTimeDuration)o;
            if (this.getMilisecond() < duration.getMilisecond()) {
                return -1;
            }
            if (this.getMilisecond() > duration.getMilisecond()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }
}

