/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.runtime.BgelObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BgelRange
extends BgelObject
implements List {
    private Comparable from;
    private Comparable to;
    private Object step;
    private boolean includeFrom;
    private boolean includeTo;
    private int size = 0;

    public BgelRange(Comparable from, Comparable to, Object step, boolean includeFrom, boolean includeTo) {
        this.from = from;
        this.to = to;
        this.includeFrom = includeFrom;
        this.includeTo = includeTo;
        if (step == null) {
            if ((from instanceof Integer || from instanceof Long) && (to instanceof Integer || to instanceof Long)) {
                step = 1;
            } else if (from instanceof Character && to instanceof Character) {
                step = 1;
            } else if (from instanceof Byte && to instanceof Byte) {
                step = 1;
            }
        }
        this.step = step;
        this.size = 0;
    }

    public Comparable getFrom() {
        return this.from;
    }

    public Comparable getTo() {
        return this.to;
    }

    public Object getStep() {
        return this.step;
    }

    public boolean isIncludeFrom() {
        return this.includeFrom;
    }

    public boolean isIncludeTo() {
        return this.includeTo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.includeFrom ? (char)'[' : '(');
        builder.append(this.from);
        builder.append("..");
        builder.append(this.to);
        builder.append(this.includeTo ? (char)']' : ')');
        return builder.toString();
    }

    protected int intStepValue() {
        if (this.step instanceof Integer) {
            return (Integer)this.step;
        }
        if (this.step instanceof Float) {
            return (int)((Float)this.step).floatValue();
        }
        if (this.step instanceof Integer) {
            return (Integer)this.step;
        }
        if (this.step instanceof Float) {
            return ((Float)this.step).intValue();
        }
        return 1;
    }

    protected Object increment(Object value, int i) {
        if (i <= 0) {
            return value;
        }
        if (value instanceof Integer) {
            return (Integer)value + i;
        }
        if (value instanceof Integer) {
            return (Integer)value + i;
        }
        for (int j = 0; j < i; ++j) {
            value = this.increment(value);
        }
        return value;
    }

    protected Object increment(Object value) {
        if (value instanceof Integer) {
            return new Integer((Integer)value + this.intStepValue());
        }
        if (value instanceof Character) {
            return new Character((char)(((Character)value).charValue() + this.intStepValue()));
        }
        if (value instanceof Integer) {
            return (Integer)value + (Integer)this.step;
        }
        if (value instanceof CharSequence) {
            int len = ((CharSequence)value).length();
            int pos = 1;
            int intStep = this.intStepValue();
            char lastC = ((CharSequence)value).charAt(len - pos);
            lastC = (char)(lastC + intStep);
            return ((CharSequence)value).subSequence(0, len - pos) + String.valueOf(lastC);
        }
        return null;
    }

    public List get(int index1, int index2) {
        return this.subList(index1, index2);
    }

    public Object get(int i) {
        if (i < 0) {
            i = this.size() + i;
        }
        if (i >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + i + " is too big for range: " + this);
        }
        Object value = this.from;
        if (!this.includeFrom) {
            value = this.increment(value);
        }
        value = this.increment(value, i);
        return value;
    }

    public Object set(int index, Object element) {
        return null;
    }

    public void add(int index, Object element) {
    }

    public Object remove(int index) {
        return null;
    }

    private int includeSize(int s) {
        if (this.includeFrom && this.includeTo) {
            return s + 1;
        }
        if (!this.includeFrom && this.includeTo) {
            return s;
        }
        if (this.includeFrom && !this.includeTo) {
            return s;
        }
        return s - 1;
    }

    private BigInteger includeSize(BigDecimal s) {
        if (this.includeFrom && this.includeTo) {
            return s.add(new BigDecimal("1")).toBigInteger();
        }
        if (!this.includeFrom && this.includeTo) {
            return s.toBigInteger();
        }
        if (this.includeFrom && !this.includeTo) {
            return s.toBigInteger();
        }
        return s.subtract(new BigDecimal("1")).toBigInteger();
    }

    @Override
    public int size() {
        if (this.size == 0) {
            if ((this.from instanceof Integer || this.from instanceof Long) && (this.to instanceof Integer || this.to instanceof Long)) {
                long fromNum = ((Number)((Object)this.from)).longValue();
                long toNum = ((Number)((Object)this.to)).longValue();
                this.size = this.includeSize((int)(toNum - fromNum));
            } else if (this.from instanceof Character && this.to instanceof Character) {
                char fromNum = ((Character)this.from).charValue();
                char toNum = ((Character)this.to).charValue();
                this.size = this.includeSize(toNum - fromNum);
            } else if (this.from instanceof BigDecimal || this.to instanceof BigDecimal || this.from instanceof BigInteger || this.to instanceof BigInteger) {
                BigDecimal fromNum = new BigDecimal("" + this.from);
                BigDecimal toNum = new BigDecimal("" + this.to);
                BigInteger sizeNum = toNum.subtract(fromNum).add(new BigDecimal(1.0)).toBigInteger();
                this.size = this.includeSize(toNum.subtract(fromNum)).intValue();
            } else {
                this.size = 0;
                Comparable first = this.from;
                Comparable value = this.from;
                while (this.to.compareTo(value) >= 0) {
                    value = (Comparable)this.increment(value);
                    ++this.size;
                    if (first.compareTo(value) < 0) continue;
                }
            }
            if (!this.includeFrom) {
                --this.size;
            }
            if (!this.includeTo) {
                --this.size;
            }
        }
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Comparable) {
            Comparable obj = (Comparable)o;
            int fromResult = this.from == null ? 0 : obj.compareTo(this.from);
            int toResult = this.to == null ? 0 : obj.compareTo(this.to);
            if (this.includeFrom && this.includeTo) {
                return fromResult >= 0 && toResult <= 0;
            }
            if (this.includeFrom && !this.includeTo) {
                return fromResult >= 0 && toResult < 0;
            }
            if (!this.includeFrom && this.includeTo) {
                return fromResult > 0 && toResult <= 0;
            }
            if (!this.includeFrom && !this.includeTo) {
                return fromResult > 0 && toResult < 0;
            }
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < BgelRange.this.size();
            }

            public Object next() {
                return BgelRange.this.get(++this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object item : c) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return -1;
    }

    public ListIterator listIterator() {
        return null;
    }

    public ListIterator listIterator(int index) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public List subList(int index1, int index2) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (index1 < 0) {
            index1 = this.size() + index1;
        }
        if (index2 < 0) {
            index2 = this.size() + index2;
        }
        if (index2 > index1) {
            index2 = Math.min(index2, this.size() - 1);
            for (int i = index1; i <= index2; ++i) {
                ret.add(this.get(i));
            }
        } else {
            ret.add(this.get(index1));
        }
        return ret;
    }

    @Override
    public Object[] toArray() {
        int len = this.size();
        Object[] rets = new Object[len];
        for (int i = 0; i < len; ++i) {
            rets[i] = this.get(i);
        }
        return rets;
    }

    @Override
    public boolean add(Object o) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean addAll(Collection c) {
        return false;
    }

    public boolean addAll(int index, Collection c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean retainAll(Collection c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        return false;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return null;
    }

    public BgelRange and(BgelRange right) {
        return right;
    }

    public BgelRange or(BgelRange right) {
        return right;
    }

    public boolean isMatch(Object obj) {
        return this.contains(obj);
    }
}

