/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.exception;

import com.thebeastshop.bgel.compile.BgelSourceLine;
import com.thebeastshop.bgel.compile.BgelSourcePosition;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import java.util.List;

public class BgelException
extends RuntimeException {
    public BgelException(BgelRuntimeContext context, BgelSourcePosition position, String msg) {
        super(BgelException.getErrorMsg(context, position, msg));
    }

    public BgelException(BgelRuntimeContext context, BgelSourcePosition position, String msg, Throwable cause) {
        super(BgelException.getErrorMsg(context, position, msg), cause);
    }

    private static String getErrorMsg(BgelRuntimeContext context, BgelSourcePosition position, String msg) {
        return "\n\n    [BGEL] Error: " + msg + "\n\n" + BgelException.getIndentSpace(11) + "Source: \n\n" + BgelException.getSourcePart(context, position, 15);
    }

    private static String getSourcePart(BgelRuntimeContext context, BgelSourcePosition position, int indent) {
        List<BgelSourceLine> lineList = context.getSource().getLineList(0, position.getEndLine());
        if (lineList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int startLine = position.getStartLine();
        int startColumn = position.getStartColumn();
        for (BgelSourceLine line : lineList) {
            builder.append(BgelException.getIndentSpace(indent));
            builder.append(line.getLine());
            if (line.getLineNumber() == startLine) {
                int i;
                builder.append('\n');
                builder.append(BgelException.getIndentSpace(indent));
                for (i = 0; i < startColumn; ++i) {
                    builder.append(' ');
                }
                for (i = startColumn; i < position.getEndColumn(); ++i) {
                    builder.append('^');
                }
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    private static String getIndentSpace(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }
}

