/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.compile;

import com.thebeastshop.bgel.compile.BgelSourceLine;
import com.thebeastshop.bgel.compile.BgelSourcePosition;
import com.thebeastshop.bgel.exception.BgelRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;

public class BgelSource {
    public static final int SOURCE_TEXT = 1;
    public static final int SOURCE_FILE = 2;
    private InputStream inputStream;
    private String sourceText;
    private int sourceType;
    private String sourceName;

    public BgelSource(String text) {
        this((InputStream)new ReaderInputStream((Reader)new StringReader(text)), 1, "<SCRIPT>");
        this.sourceText = text;
    }

    public BgelSource(File file) throws FileNotFoundException {
        this(new FileInputStream(file), 2, file.getAbsolutePath());
    }

    public BgelSource(InputStream inputStream, int sourceType, String sourceName) {
        this.inputStream = inputStream;
        this.sourceType = sourceType;
        this.sourceName = sourceName;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public List<BgelSourceLine> getLineList(int startLine, int endLine) {
        BufferedReader reader = new BufferedReader(new StringReader(this.sourceText));
        int lineNum = 1;
        LinkedList<BgelSourceLine> lineList = new LinkedList<BgelSourceLine>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (lineNum >= startLine && lineNum <= endLine) {
                    lineList.add(new BgelSourceLine(lineNum, line));
                }
                ++lineNum;
            }
        }
        catch (IOException e) {
            throw new BgelRuntimeException("Failed read source at line " + lineNum);
        }
        return lineList;
    }

    public List<BgelSourceLine> getLineList(BgelSourcePosition position) {
        return this.getLineList(position.getStartLine(), position.getEndLine());
    }
}

