/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.ast;

import com.thebeastshop.bgel.runtime.BgelDate;
import com.thebeastshop.bgel.runtime.BgelRange;
import com.thebeastshop.bgel.runtime.BgelTimeDuration;
import com.thebeastshop.bgel.utils.TypeHelper;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class BgelType {
    public static final BgelType UNDEFINED = new BgelType("Undefined");
    public static final BgelType OBJECT;
    public static final BgelType BOOLEAN;
    public static final BgelType INTEGER;
    public static final BgelType NUMERIC;
    public static final BgelType STRING;
    public static final BgelType RANGE;
    public static final BgelType LIST;
    public static final BgelType MAP;
    public static final BgelType MAP_ENTRY;
    public static final BgelType DATE;
    public static final BgelType TIME_DURATION;
    private final String typeName;
    private Class clazz;
    private boolean isUndefined = false;

    public static BgelType convertFromJavaClass(Class cls) {
        if (TypeHelper.isInteger(cls)) {
            return INTEGER;
        }
        if (TypeHelper.isNumeric(cls)) {
            return NUMERIC;
        }
        if (TypeHelper.isString(cls)) {
            return STRING;
        }
        if (TypeHelper.isBoolean(cls)) {
            return BOOLEAN;
        }
        return OBJECT;
    }

    public BgelType(String typeName, Class clazz) {
        this.typeName = typeName;
        this.clazz = clazz;
    }

    public BgelType(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public boolean isUndefined() {
        return this.isUndefined;
    }

    public void setUndefined(boolean undefined) {
        this.isUndefined = undefined;
    }

    static {
        UNDEFINED.setUndefined(true);
        OBJECT = new BgelType("Object", Object.class);
        BOOLEAN = new BgelType("Boolean", Boolean.class);
        INTEGER = new BgelType("Integer", Integer.class);
        NUMERIC = new BgelType("Numeric", BigDecimal.class);
        STRING = new BgelType("String", String.class);
        RANGE = new BgelType("Range", BgelRange.class);
        LIST = new BgelType("List", List.class);
        MAP = new BgelType("Map", Map.class);
        MAP_ENTRY = new BgelType("MapEntry", Map.Entry.class);
        DATE = new BgelType("Date", BgelDate.class);
        TIME_DURATION = new BgelType("Date", BgelTimeDuration.class);
    }
}

