/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.ast;

import com.thebeastshop.bgel.antlr.BgelParser;
import com.thebeastshop.bgel.antlr.BgelParserBaseVisitor;
import com.thebeastshop.bgel.ast.ASTAccessExpression;
import com.thebeastshop.bgel.ast.ASTConstant;
import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTIdentifier;
import com.thebeastshop.bgel.ast.ASTInvokeExpression;
import com.thebeastshop.bgel.ast.ASTList;
import com.thebeastshop.bgel.ast.ASTMapEntry;
import com.thebeastshop.bgel.ast.ASTNode;
import com.thebeastshop.bgel.ast.ASTRange;
import com.thebeastshop.bgel.transform.AccessExpressionTransformer;
import com.thebeastshop.bgel.transform.BinaryExpressionTransformer;
import com.thebeastshop.bgel.transform.ConstantTransformer;
import com.thebeastshop.bgel.transform.DateTransformer;
import com.thebeastshop.bgel.transform.IdentifierTransformer;
import com.thebeastshop.bgel.transform.InvokeExpressionTransformer;
import com.thebeastshop.bgel.transform.ListTransformer;
import com.thebeastshop.bgel.transform.MapEntryTransformer;
import com.thebeastshop.bgel.transform.MapTransformer;
import com.thebeastshop.bgel.transform.NegativeExpressionTransformer;
import com.thebeastshop.bgel.transform.NotExpressionTransformer;
import com.thebeastshop.bgel.transform.NullTransformer;
import com.thebeastshop.bgel.transform.RangeTransformer;
import com.thebeastshop.bgel.transform.TimeDurationTransformer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.RuleNode;

public class ASTTransformVisitor
extends BgelParserBaseVisitor<ASTNode> {
    private static final NullTransformer nullTransformer = new NullTransformer();
    private static final ConstantTransformer constantTransformer = new ConstantTransformer();
    private static final RangeTransformer rangeTransformer = new RangeTransformer();
    private static final DateTransformer dateTransformer = new DateTransformer();
    private static final TimeDurationTransformer timeDurationTransformer = new TimeDurationTransformer();
    private static final BinaryExpressionTransformer binaryExpressionTransformer = new BinaryExpressionTransformer();
    private static final NegativeExpressionTransformer negativeExpressionTransformer = new NegativeExpressionTransformer();
    private static final NotExpressionTransformer notExpressionTransformer = new NotExpressionTransformer();
    private static final AccessExpressionTransformer accessExpressionTransformer = new AccessExpressionTransformer();
    private static final InvokeExpressionTransformer invokeExpressionTransformer = new InvokeExpressionTransformer();
    private static final IdentifierTransformer identifierTransformer = new IdentifierTransformer();
    private static final ListTransformer listTransformer = new ListTransformer();
    private static final MapEntryTransformer mapEntryTransformer = new MapEntryTransformer();
    private static final MapTransformer mapTransformer = new MapTransformer();

    @Override
    public ASTNode visitPathExpression(BgelParser.PathExpressionContext ctx) {
        ASTExpression firstExpr = (ASTExpression)this.visitPrimary(ctx.primary());
        List<BgelParser.PathElementContext> pathElementList = ctx.pathElement();
        ASTExpression leftExpr = firstExpr;
        for (BgelParser.PathElementContext pathElement : pathElementList) {
            ASTExpression right = this.visitPathElement(pathElement);
            if (right instanceof ASTAccessExpression) {
                ((ASTAccessExpression)right).setLeft(leftExpr);
                leftExpr = right;
                continue;
            }
            if (!(right instanceof ASTInvokeExpression)) continue;
            ASTInvokeExpression invokeExpression = (ASTInvokeExpression)right;
            if (leftExpr instanceof ASTAccessExpression) {
                invokeExpression.setLeft(((ASTAccessExpression)leftExpr).getLeft());
                invokeExpression.setMethodName(((ASTAccessExpression)leftExpr).getAccessName());
                invokeExpression.setStartLineNumber(leftExpr.getStartLineNumber());
                invokeExpression.setStartColumnNumber(leftExpr.getStartColumnNumber());
                leftExpr = invokeExpression;
                continue;
            }
            if (!(leftExpr instanceof ASTIdentifier)) continue;
            invokeExpression.setLeft(null);
            invokeExpression.setMethodName(((ASTIdentifier)leftExpr).getName());
            invokeExpression.setStartLineNumber(leftExpr.getStartLineNumber());
            invokeExpression.setStartColumnNumber(leftExpr.getStartColumnNumber());
            leftExpr = invokeExpression;
        }
        return leftExpr;
    }

    @Override
    public ASTExpression visitPathElement(BgelParser.PathElementContext ctx) {
        switch (ctx.t) {
            case 1: {
                return accessExpressionTransformer.transform(ctx.dot, ctx.namePart().start);
            }
            case 2: {
                BgelParser.ArgumentsContext argumentsContext = ctx.arguments();
                BgelParser.ArgumentListContext argumentListContext = argumentsContext.argumentList();
                ArrayList<ASTExpression> argumentExprs = new ArrayList<ASTExpression>();
                if (argumentListContext != null) {
                    List<BgelParser.ArgumentListElementContext> listElementContexts = argumentListContext.argumentListElement();
                    for (BgelParser.ArgumentListElementContext elementContext : listElementContexts) {
                        ASTExpression argExpr = this.visitArgumentListElement(elementContext);
                        argumentExprs.add(argExpr);
                    }
                }
                return invokeExpressionTransformer.transform(argumentExprs, ctx.start, ctx.stop);
            }
        }
        return null;
    }

    @Override
    public ASTExpression visitArgumentListElement(BgelParser.ArgumentListElementContext ctx) {
        return this.visitExpression(ctx.expression());
    }

    @Override
    public ASTNode visitExpressionInParen(BgelParser.ExpressionInParenContext ctx) {
        return this.visitExpression(ctx.expression());
    }

    @Override
    public ASTNode visitIndexPropertyArgs(BgelParser.IndexPropertyArgsContext ctx) {
        return null;
    }

    @Override
    public ASTExpression visitExpression(BgelParser.ExpressionContext ctx) {
        Token op = ctx.op;
        BgelParser.ExpressionContext left = ctx.left;
        BgelParser.ExpressionContext right = ctx.right;
        if (op != null) {
            if (left != null && right != null) {
                ASTExpression leftExpr = this.visitExpression(left);
                ASTExpression rightExpr = this.visitExpression(right);
                return binaryExpressionTransformer.transform(leftExpr, op, ctx.not, rightExpr);
            }
            ASTExpression expr = this.visitExpression(ctx.expression(0));
            switch (op.getType()) {
                case 24: {
                    return negativeExpressionTransformer.transform(expr, ctx.start, ctx.stop);
                }
                case 23: {
                    expr.setStartLineNumber(ctx.start.getLine());
                    expr.setStartColumnNumber(ctx.start.getStartIndex());
                    return expr;
                }
                case 11: 
                case 12: {
                    return notExpressionTransformer.transform(expr, ctx.start, ctx.stop);
                }
            }
        }
        return (ASTExpression)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public ASTList visitList(BgelParser.ListContext ctx) {
        BgelParser.ListItemListContext listItemListContext = ctx.listItemList();
        if (listItemListContext == null) {
            return listTransformer.transform(null, ctx.start, ctx.stop);
        }
        List<BgelParser.ListItemContext> items = listItemListContext.listItem();
        ArrayList<ASTExpression> itemExprs = new ArrayList<ASTExpression>();
        for (BgelParser.ListItemContext item : items) {
            ASTExpression itemExpr = this.visitListItem(item);
            itemExprs.add(itemExpr);
        }
        return listTransformer.transform(itemExprs, ctx.start, ctx.stop);
    }

    @Override
    public ASTExpression visitListItem(BgelParser.ListItemContext ctx) {
        return this.visitExpression(ctx.expression());
    }

    @Override
    public ASTNode visitMap(BgelParser.MapContext ctx) {
        Token start = ctx.getStart();
        Token end = ctx.getStop();
        BgelParser.MapEntryListContext mapEntryListContext = ctx.mapEntryList();
        if (mapEntryListContext == null) {
            mapTransformer.transform(null, start, end);
        }
        List<BgelParser.MapEntryContext> entryContextList = mapEntryListContext.mapEntry();
        ArrayList<ASTMapEntry> entries = new ArrayList<ASTMapEntry>();
        for (BgelParser.MapEntryContext entryContext : entryContextList) {
            ASTMapEntry entry = this.visitMapEntry(entryContext);
            entries.add(entry);
        }
        return mapTransformer.transform(entries, start, end);
    }

    @Override
    public ASTMapEntry visitMapEntry(BgelParser.MapEntryContext ctx) {
        BgelParser.MapEntryLabelContext labelContext = ctx.mapEntryLabel();
        ASTExpression labelExpr = (ASTExpression)this.visitMapEntryLabel(labelContext);
        ASTExpression valueExpr = this.visitExpression(ctx.expression());
        return mapEntryTransformer.transform(labelExpr, valueExpr, ctx.getStart(), ctx.getStop());
    }

    @Override
    public ASTNode visitMapEntryLabel(BgelParser.MapEntryLabelContext ctx) {
        return (ASTNode)super.visitMapEntryLabel(ctx);
    }

    @Override
    public ASTNode visitNamePart(BgelParser.NamePartContext ctx) {
        return identifierTransformer.transform(ctx.getStart());
    }

    @Override
    public ASTNode visitNullLiteral(BgelParser.NullLiteralContext ctx) {
        return nullTransformer.transform(ctx.getStart());
    }

    @Override
    public ASTConstant visitIntLiteral(BgelParser.IntLiteralContext ctx) {
        String text = ctx.getText();
        BigDecimal value = new BigDecimal(text);
        return constantTransformer.transform(value, ctx.getStart(), ctx.getStop());
    }

    @Override
    public ASTConstant visitNumericLiteral(BgelParser.NumericLiteralContext ctx) {
        String text = ctx.getText();
        BigDecimal decimal = new BigDecimal(text);
        return constantTransformer.transform(decimal, ctx.getStart(), ctx.getStop());
    }

    @Override
    public ASTConstant visitStringLiteral(BgelParser.StringLiteralContext ctx) {
        String text = ctx.getText();
        String value = text.substring(1, text.length() - 1);
        return constantTransformer.transform(value, ctx.start, ctx.stop);
    }

    @Override
    public ASTRange visitRangeLiteral(BgelParser.RangeLiteralContext ctx) {
        ASTExpression leftExpr = this.visitExpression(ctx.left);
        ASTExpression rightExpr = this.visitExpression(ctx.right);
        return rangeTransformer.transform(leftExpr, rightExpr, ctx.start, ctx.stop);
    }

    @Override
    public ASTNode visitDateLiteral(BgelParser.DateLiteralContext ctx) {
        return dateTransformer.transform(ctx.yyyyMMdd, ctx.time, ctx.start, ctx.stop);
    }

    @Override
    public ASTNode visitDurationLiteral(BgelParser.DurationLiteralContext ctx) {
        return timeDurationTransformer.transform(ctx.start);
    }

    @Override
    public ASTNode visitBooleanLiteral(BgelParser.BooleanLiteralContext ctx) {
        String text = ctx.getText();
        Boolean value = "true".equals(text);
        return constantTransformer.transform(value, ctx.start, ctx.stop);
    }

    @Override
    public ASTIdentifier visitKeywords(BgelParser.KeywordsContext ctx) {
        return identifierTransformer.transform(ctx.start);
    }
}

