/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.ast;

import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTVisitor;
import com.thebeastshop.bgel.ast.BgelType;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import java.util.List;

public class ASTList
extends ASTExpression {
    private final List<ASTExpression> listItems;

    public ASTList(List<ASTExpression> listItems) {
        super(BgelType.LIST);
        this.listItems = listItems;
    }

    public List<ASTExpression> getListItems() {
        return this.listItems;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < this.listItems.size(); ++i) {
            ASTExpression item = this.listItems.get(i);
            builder.append(item);
            if (i >= this.listItems.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public String getText() {
        return this.toString();
    }

    @Override
    public void visit(BgelRuntimeContext context, ASTVisitor visitor) {
        visitor.visitList(context, this);
    }
}

