/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bagua.dto;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.bagua.dto.Image;
import com.thebeastshop.bagua.dto.Video;
import com.thebeastshop.bagua.enums.AnnexTypeEnum;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ArticleAnnex {
    private AnnexTypeEnum type;
    private List<Image> images;
    private Video video;

    public String buildShareImage() {
        String imageSrc = "";
        if (AnnexTypeEnum.IMAGE.equals((Object)this.type) && CollectionUtils.isNotEmpty(this.images)) {
            imageSrc = this.images.get(0).getSrc();
        }
        if (AnnexTypeEnum.VIDEO.equals((Object)this.type) && null != this.video && null != this.video.getCoverImage()) {
            imageSrc = this.video.getCoverImage().getSrc();
        }
        return imageSrc;
    }

    public static ArticleAnnex Builder(AnnexTypeEnum type, String annexContent) {
        ArticleAnnex articleAnnex = new ArticleAnnex();
        if (null == type) {
            return null;
        }
        articleAnnex.setType(type);
        try {
            if (StringUtils.isNotEmpty((CharSequence)annexContent)) {
                switch (type) {
                    case IMAGE: {
                        articleAnnex.setImages(JSONObject.parseArray((String)annexContent, Image.class));
                        break;
                    }
                    case VIDEO: {
                        articleAnnex.setVideo((Video)JSONObject.parseObject((String)annexContent, Video.class));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return articleAnnex;
    }

    public AnnexTypeEnum getType() {
        return this.type;
    }

    public void setType(AnnexTypeEnum type) {
        this.type = type;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }
}

