package com.thebeastshop.scm.po;

import java.math.BigDecimal;
import java.util.Date;

import pers.richard.ormybatis.domain.po.IdPo;

public class SalesOrder extends IdPo {
	private String code;
	private String outerOrderCode;
	private String sourceSoCode;
	private String groupContractCode;
	private Integer salesOrderType;
	private Integer salesOrderStatus;
	private String channelCode;
	private String memberCode;
	private Integer createOperatorId;
	private String createOperatorName;
	private Date createTime;
	private Date cancelTime;
	private Date payTime;
	private Date auditTime;
	private BigDecimal totalAmount;
	private BigDecimal discountOnHead;
	private BigDecimal discountOnLine;
	private BigDecimal totalAmountAfterDiscount;
	private BigDecimal pointOnHead;
	private BigDecimal pointOnLine;
	private BigDecimal pointOnHeadDeduction;
	private BigDecimal pointOnLineDeduction;
	private BigDecimal serviceFeeAmount;
	private BigDecimal giftCardAmount;
	private BigDecimal needToPayAmount;
	private Integer paymentType;
	private Integer isAnonymous;
	private Integer needInvoice;
	private Integer isInvoiceInSamePackage;
	private String couponCode;
	private BigDecimal couponDiscountAmount;
	private String giftCardDesc;
	private String remark;
	private String innerRemark;
	private String foodSpecific;
	private Integer isForceAudit;
	private Integer isDownload;
	private String secondOrderSource;
	private Integer hideFlag;
	private String buyerNick;
	private Float crossBorderFee;
	private Integer crossBorderFlag;
	private String refundStatus;
	private String tradeNo;
	
	public SalesOrder(){}
	
	public final static String
		F_CODE = "code",
		F_OUTER_ORDER_CODE = "outer_order_code",
		F_SOURCE_SO_CODE = "source_so_code",
		F_GROUP_CONTRACT_CODE = "group_contract_code",
		F_SALES_ORDER_TYPE = "sales_order_type",
		F_SALES_ORDER_STATUS = "sales_order_status",
		F_CHANNEL_CODE = "channel_code",
		F_MEMBER_CODE = "member_code",
		F_CREATE_OPERATOR_ID = "create_operator_id",
		F_CREATE_OPERATOR_NAME = "create_operator_name",
		F_CREATE_TIME = "create_time",
		F_CANCEL_TIME = "cancel_time",
		F_PAY_TIME = "pay_time",
		F_AUDIT_TIME = "audit_time",
		F_TOTAL_AMOUNT = "total_amount",
		F_DISCOUNT_ON_HEAD = "discount_on_head",
		F_DISCOUNT_ON_LINE = "discount_on_line",
		F_TOTAL_AMOUNT_AFTER_DISCOUNT = "total_amount_after_discount",
		F_POINT_ON_HEAD = "point_on_head",
		F_POINT_ON_LINE = "point_on_line",
		F_POINT_ON_HEAD_DEDUCTION = "point_on_head_deduction",
		F_POINT_ON_LINE_DEDUCTION = "point_on_line_deduction",
		F_SERVICE_FEE_AMOUNT = "service_fee_amount",
		F_GIFT_CARD_AMOUNT = "gift_card_amount",
		F_NEED_TO_PAY_AMOUNT = "need_to_pay_amount",
		F_PAYMENT_TYPE = "payment_type",
		F_IS_ANONYMOUS = "is_anonymous",
		F_NEED_INVOICE = "need_invoice",
		F_IS_INVOICE_IN_SAME_PACKAGE = "is_invoice_in_same_package",
		F_COUPON_CODE = "coupon_code",
		F_COUPON_DISCOUNT_AMOUNT = "coupon_discount_amount",
		F_GIFT_CARD_DESC = "gift_card_desc",
		F_REMARK = "remark",
		F_INNER_REMARK = "inner_remark",
		F_FOOD_SPECIFIC = "food_specific",
		F_IS_FORCE_AUDIT = "is_force_audit",
		F_IS_DOWNLOAD = "is_download",
		F_SECOND_ORDER_SOURCE = "second_order_source",
		F_HIDE_FLAG = "hide_flag",
		F_BUYER_NICK = "buyer_nick",
		F_CROSS_BORDER_FEE = "cross_border_fee",
		F_CROSS_BORDER_FLAG = "cross_border_flag",
		F_REFUND_STATUS = "refund_status",
		F_TRADE_NO = "trade_no";

	 /**
     * 订单类型~渠道销售单
     */
    public static final int ORDER_TYPE_SALES = 1;
    /**
     * 订单类型~渠道换货单
     */
    public static final int ORDER_TYPE_EXCHANGE = 2;
    /**
     * 订单类型~集团订单
     */
    public static final int ORDER_TYPE_GROUP = 3;
	/**
	 * 订单类型~渠道补货单
	 */
	public static final int ORDER_TYPE_REPLENISH = 4;
    /**
     * 订单类型~礼品订单
     */
    public static final int ORDER_TYPE_GIFT = 11;
    /**
     * 订单类型~样品订单
     */
    public static final int ORDER_TYPE_SAMPLE = 12;

    /**
     * 订单类型~第三方订单
     */
    public static final int ORDER_TYPE_THIRD = 13;


    // salesOrderStatus
    /**
     * 订单状态~取消
     */
    public static final int ORDER_STATUS_CANCLE = 0;
    /**
     * 订单状态~未付款
     */
    public static final int ORDER_STATUS_NONPAYMENT = 1;
    /**
     * 订单状态~未付款挂起
     */
    public static final int ORDER_STATUS_HOLD = 2;
	/**
	 * 订单状态~待审批
	 */
	public static final int ORDER_STATUS_NOAUDIT = 3;
    /**
     * 订单状态~换货待收货
     */
    public static final int ORDER_STATUS_CHANGE_AFTER_RECEIVE = 5;
    /**
     * 订单状态~审单挂起
     */
    public static final int ORDER_STATUS_HOLD_REVIEW = 9;
    /**
     * 订单状态~待审单
     */
    public static final int ORDER_STATUS_WAITING_REVIEW = 10;
    /**
     * 订单状态~已审单
     */
    public static final int ORDER_STATUS_ALREADY_REVIEW = 11;
    /**
     * 订单状态~已完成
     */
    public static final int ORDER_STATUS_ALREADY_FINISHED = 12;

    // paymentType 参考 PegasusConstants.Payment Class

    // isAnonymous
    /**
     * 匿名发送~是
     */
    public static final int IS_ANONYMOUS_TRUE = 1;
    /**
     * 匿名发送~否
     */
    public static final int IS_ANONYMOUS_FALSE = 0;

    // needInvoice
    /**
     * 需要发票~是
     */
    public static final int NEED_INVOICE_TRUE = 1;  
    /**
     * 需要发票~否
     */
    public static final int NEED_INVOICE_FALSE = 0;

    // PAYMENT_TYPE 支付方式，0客服1现金2借记卡3信用卡4微信5支付宝6招行7转账
    public static final Integer TYPE_CUSTOMER_SERVICE = 0;	// 客服
    public static final Integer TYPE_CASH = 1;				// 现金
    public static final Integer TYPE_DEBIT_CARD = 2;		// 借记卡
    public static final Integer TYPE_CREDIT_CARD = 3;		// 信用卡
    public static final Integer TYPE_WEIXIN = 4;			// 微信
    public static final Integer TYPE_ALIPAY = 5;			// 支付宝
    public static final Integer TYPE_CMB = 6;				// 招行
    public static final Integer TYPE_TRANSFER = 7;			// 转账

	public String getCode() {return code;}
	public void setCode(String code) {this.code = code;}

	public String getOuterOrderCode() {return outerOrderCode;}
	public void setOuterOrderCode(String outerOrderCode) {this.outerOrderCode = outerOrderCode;}

	public String getSourceSoCode() {return sourceSoCode;}
	public void setSourceSoCode(String sourceSoCode) {this.sourceSoCode = sourceSoCode;}

	public String getGroupContractCode() {return groupContractCode;}
	public void setGroupContractCode(String groupContractCode) {this.groupContractCode = groupContractCode;}

	public Integer getSalesOrderType() {return salesOrderType;}
	public void setSalesOrderType(Integer salesOrderType) {this.salesOrderType = salesOrderType;}

	public Integer getSalesOrderStatus() {return salesOrderStatus;}
	public void setSalesOrderStatus(Integer salesOrderStatus) {this.salesOrderStatus = salesOrderStatus;}

	public String getChannelCode() {return channelCode;}
	public void setChannelCode(String channelCode) {this.channelCode = channelCode;}

	public String getMemberCode() {return memberCode;}
	public void setMemberCode(String memberCode) {this.memberCode = memberCode;}

	public Integer getCreateOperatorId() {return createOperatorId;}
	public void setCreateOperatorId(Integer createOperatorId) {this.createOperatorId = createOperatorId;}

	public String getCreateOperatorName() {return createOperatorName;}
	public void setCreateOperatorName(String createOperatorName) {this.createOperatorName = createOperatorName;}

	public Date getCreateTime() {return createTime;}
	public void setCreateTime(Date createTime) {this.createTime = createTime;}

	public Date getCancelTime() {return cancelTime;}
	public void setCancelTime(Date cancelTime) {this.cancelTime = cancelTime;}

	public Date getPayTime() {return payTime;}
	public void setPayTime(Date payTime) {this.payTime = payTime;}

	public Date getAuditTime() {return auditTime;}
	public void setAuditTime(Date auditTime) {this.auditTime = auditTime;}

	public BigDecimal getTotalAmount() {return totalAmount;}
	public void setTotalAmount(BigDecimal totalAmount) {this.totalAmount = totalAmount;}

	public BigDecimal getDiscountOnHead() {return discountOnHead;}
	public void setDiscountOnHead(BigDecimal discountOnHead) {this.discountOnHead = discountOnHead;}

	public BigDecimal getDiscountOnLine() {return discountOnLine;}
	public void setDiscountOnLine(BigDecimal discountOnLine) {this.discountOnLine = discountOnLine;}

	public BigDecimal getTotalAmountAfterDiscount() {return totalAmountAfterDiscount;}
	public void setTotalAmountAfterDiscount(BigDecimal totalAmountAfterDiscount) {this.totalAmountAfterDiscount = totalAmountAfterDiscount;}

	public BigDecimal getPointOnHead() {return pointOnHead;}
	public void setPointOnHead(BigDecimal pointOnHead) {this.pointOnHead = pointOnHead;}

	public BigDecimal getPointOnLine() {return pointOnLine;}
	public void setPointOnLine(BigDecimal pointOnLine) {this.pointOnLine = pointOnLine;}

	public BigDecimal getPointOnHeadDeduction() {return pointOnHeadDeduction;}
	public void setPointOnHeadDeduction(BigDecimal pointOnHeadDeduction) {this.pointOnHeadDeduction = pointOnHeadDeduction;}

	public BigDecimal getPointOnLineDeduction() {return pointOnLineDeduction;}
	public void setPointOnLineDeduction(BigDecimal pointOnLineDeduction) {this.pointOnLineDeduction = pointOnLineDeduction;}

	public BigDecimal getServiceFeeAmount() {return serviceFeeAmount;}
	public void setServiceFeeAmount(BigDecimal serviceFeeAmount) {this.serviceFeeAmount = serviceFeeAmount;}

	public BigDecimal getGiftCardAmount() {return giftCardAmount;}
	public void setGiftCardAmount(BigDecimal giftCardAmount) {this.giftCardAmount = giftCardAmount;}

	public BigDecimal getNeedToPayAmount() {return needToPayAmount;}
	public void setNeedToPayAmount(BigDecimal needToPayAmount) {this.needToPayAmount = needToPayAmount;}

	public Integer getPaymentType() {return paymentType;}
	public void setPaymentType(Integer paymentType) {this.paymentType = paymentType;}

	public Integer getIsAnonymous() {return isAnonymous;}
	public void setIsAnonymous(Integer isAnonymous) {this.isAnonymous = isAnonymous;}

	public Integer getNeedInvoice() {return needInvoice;}
	public void setNeedInvoice(Integer needInvoice) {this.needInvoice = needInvoice;}

	public Integer getIsInvoiceInSamePackage() {return isInvoiceInSamePackage;}
	public void setIsInvoiceInSamePackage(Integer isInvoiceInSamePackage) {this.isInvoiceInSamePackage = isInvoiceInSamePackage;}

	public String getCouponCode() {return couponCode;}
	public void setCouponCode(String couponCode) {this.couponCode = couponCode;}

	public BigDecimal getCouponDiscountAmount() {return couponDiscountAmount;}
	public void setCouponDiscountAmount(BigDecimal couponDiscountAmount) {this.couponDiscountAmount = couponDiscountAmount;}

	public String getGiftCardDesc() {return giftCardDesc;}
	public void setGiftCardDesc(String giftCardDesc) {this.giftCardDesc = giftCardDesc;}

	public String getRemark() {return remark;}
	public void setRemark(String remark) {this.remark = remark;}

	public String getInnerRemark() {return innerRemark;}
	public void setInnerRemark(String innerRemark) {this.innerRemark = innerRemark;}

	public String getFoodSpecific() {return foodSpecific;}
	public void setFoodSpecific(String foodSpecific) {this.foodSpecific = foodSpecific;}

	public Integer getIsForceAudit() {return isForceAudit;}
	public void setIsForceAudit(Integer isForceAudit) {this.isForceAudit = isForceAudit;}

	public Integer getIsDownload() {return isDownload;}
	public void setIsDownload(Integer isDownload) {this.isDownload = isDownload;}

	public String getSecondOrderSource() {return secondOrderSource;}
	public void setSecondOrderSource(String secondOrderSource) {this.secondOrderSource = secondOrderSource;}

	public Integer getHideFlag() {return hideFlag;}
	public void setHideFlag(Integer hideFlag) {this.hideFlag = hideFlag;}

	public String getBuyerNick() {return buyerNick;}
	public void setBuyerNick(String buyerNick) {this.buyerNick = buyerNick;}

	public Float getCrossBorderFee() {return crossBorderFee;}
	public void setCrossBorderFee(Float crossBorderFee) {this.crossBorderFee = crossBorderFee;}

	public Integer getCrossBorderFlag() {return crossBorderFlag;}
	public void setCrossBorderFlag(Integer crossBorderFlag) {this.crossBorderFlag = crossBorderFlag;}

	public String getRefundStatus() {return refundStatus;}
	public void setRefundStatus(String refundStatus) {this.refundStatus = refundStatus;}

	public String getTradeNo() {return tradeNo;}
	public void setTradeNo(String tradeNo) {this.tradeNo = tradeNo;}
}