package com.thebeastshop.scm.po;

import pers.richard.ormybatis.domain.po.IdPo;

import java.util.Date;

/**
 * t_op_so_package_card
 *
 * 包裹卡片表
 * @author 徐玲玲
 *
 * 2020年5月14日
 */
public class SoPackageCard extends IdPo {

	private Long salesOrderId;

	private Long packageId;

	private Integer cardType;

	private Integer quantity;

	private String cardFrom;

	private String cardTo;

	private String cardContent;

	private Date createTime;


	public Long getSalesOrderId() {
		return salesOrderId;
	}

	public void setSalesOrderId(Long salesOrderId) {
		this.salesOrderId = salesOrderId;
	}

	public Long getPackageId() {
		return packageId;
	}

	public void setPackageId(Long packageId) {
		this.packageId = packageId;
	}

	public Integer getCardType() {
		return cardType;
	}

	public void setCardType(Integer cardType) {
		this.cardType = cardType;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public String getCardFrom() {
		return cardFrom;
	}

	public void setCardFrom(String cardFrom) {
		this.cardFrom = cardFrom;
	}

	public String getCardTo() {
		return cardTo;
	}

	public void setCardTo(String cardTo) {
		this.cardTo = cardTo;
	}

	public String getCardContent() {
		return cardContent;
	}

	public void setCardContent(String cardContent) {
		this.cardContent = cardContent;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 卡片类型~不需要
	 */
	public static final Integer CARD_TYPE_NULL = 0;
	/**
	 * 卡片类型~空白
	 */
	public static final Integer CARD_TYPE_BLANK_ = 1;
	/**
	 * 卡片类型~代写
	 */
	public static final Integer CARD_TYPE_GHOSTWRITE = 2;

	/**
	 * 卡片类型~语音卡
	 */
	public static final Integer CARD_TYPE_VOICE = 3;

	/**
	 * 卡片类型
	 *
	 * @return
	 */
	public String getCardTypeName() {
		return cardType == null ? "" :
				cardType.equals(CARD_TYPE_NULL) ? "不需要" :
						cardType.equals(CARD_TYPE_BLANK_) ? "空白" :
								cardType.equals(CARD_TYPE_GHOSTWRITE) ? "代写" :
										cardType.equals(CARD_TYPE_VOICE)?"录音卡":"";
	}
}