package com.thebeastshop.scm.po;


import java.util.LinkedHashMap;
import java.util.Map;

import pers.richard.ormybatis.domain.po.IdPo;

public class LotteryActivityPrize extends IdPo {
	private Integer lotteryActivityAwardId;
	private String type;
	private String typeNum;
	private String imgUrl;
	
	public LotteryActivityPrize(){}
	
	public final static String
		F_LOTTERY_ACTIVITY_AWARD_ID = "lottery_activity_award_id",
		F_TYPE = "type",
		F_TYPE_NUM = "type_num";
	
	/** 奖品类型*/
	public enum Type{
		POINT("积分"),
		COUPON("优惠券"),
		COUPON_THIRD("第三券"),
		PRODUCT("商品");
		
		public String cn;
		private Type(String cn){
			this.cn = cn;
		}
		
		public static Map<String, String> getMap(){
			Map<String, String> map = new LinkedHashMap<>();
			for (Type type : Type.values()) {
				map.put(type.name(), type.cn);
			}
			return map;
		}
	}

	public Integer getLotteryActivityAwardId() {return lotteryActivityAwardId;}
	public void setLotteryActivityAwardId(Integer lotteryActivityAwardId) {this.lotteryActivityAwardId = lotteryActivityAwardId;}

	public String getType() {return type;}
	public void setType(String type) {this.type = type;}

	public String getTypeNum() {return typeNum;}
	public void setTypeNum(String typeNum) {this.typeNum = typeNum;}
	public String getImgUrl() {
		return imgUrl;
	}
	public void setImgUrl(String imgUrl) {
		this.imgUrl = imgUrl;
	}
	
}
