package com.thebeastshop.scm.vo.recommend;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.Recommend;

public class RecommendSaveVO extends AbstractDomain {
	private Integer id;
	private String name;
	private String rule;
	private String position;
	private List<String> productCode = new ArrayList<>();
	
	public RecommendSaveVO(){}
	
	public Recommend toRecommend(){
		Recommend recommend = new Recommend();
		recommend.setId(this.id);
		recommend.setName(this.name);
		recommend.setRule(this.rule);
		recommend.setPosition(this.position);
		recommend.setUpdateTime(new Date());
		if (this.id == null) {
			recommend.setCreateTime(new Date());
		}
		return recommend;
	}
	
	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getRule() {
		return rule;
	}

	public void setRule(String rule) {
		this.rule = rule;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public List<String> getProductCode() {
		return productCode;
	}

	public void setProductCode(List<String> productCode) {
		this.productCode = productCode;
	}
}