package com.thebeastshop.scm.es;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2019/8/14 11:49
 * 人工推荐选购页
 */
public enum RecommendSceneTypeEnum {
    COMMON(1, "默认ID"),
    PRODUCT_DETAIL(2, "商品详情"),
    ORDER_DETAIL(3, "订单详情"),
    SUCCESS(4, "购买成功"),
    DELIVERYINFO(5, "物流详情"),
    CART(6, "购物车"),
    MY_CENTER(7, "个人中心"),
    SHARE_ORDER_DETAIL(8, "晒单详情"),
    POST_DETAIL(9, "社区帖子详情页"),
    ;

    private final int id;

    private final String name;

    public static final List<RecommendSceneTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    RecommendSceneTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static RecommendSceneTypeEnum getById(int id) {
        for (RecommendSceneTypeEnum e : RecommendSceneTypeEnum.values()) {
            if (e.getId() == id) {
                return e;
            }
        }
        return null;
    }

}
