package com.thebeastshop.scm.vo.interest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import pers.richard.ormybatis.domain.core.AbstractDomain;
import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.scm.po.InterestGoodsSku;

/**
 * 编辑商品领用权益保存VO 
 * @author donghui
 */
public class InterestGoodsSaveVO extends AbstractDomain {
	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;
	private Integer id;
	private String prodCode;
	private Integer isFreePost;
	private Date receiptStartTime;
	private Date receiptEndTime;
	private Date cashStartTime;
	private Date cashEndTime;
	private Integer status;
	private List<Integer> interestGoodsSkuId = new ArrayList<>();
	private List<String> skuCode = new ArrayList<>();
	private List<String> skuNameCn = new ArrayList<>();
	private List<Integer> quantity = new ArrayList<>();//sku可领取数量
	private BigDecimal cashThreshold;


	private List<BigDecimal> deductionPrice = new ArrayList<BigDecimal>(); //抵扣价格

	public InterestGoodsSaveVO(){}
	
	public InterestGoods toInterestGoods(){
		InterestGoods interestGoods = new InterestGoods();
		interestGoods.setId(this.id);
		interestGoods.setProdCode(this.prodCode);
		interestGoods.setIsFreePost(this.isFreePost);
		interestGoods.setReceiptStartTime(this.receiptStartTime);
		interestGoods.setReceiptEndTime(this.receiptEndTime);
		interestGoods.setCashStartTime(this.cashStartTime);
		interestGoods.setCashEndTime(this.cashEndTime);
		interestGoods.setCashThreshold(this.cashThreshold == null ? new BigDecimal(0) : this.cashThreshold);
		if (this.id == null) {
			interestGoods.setStatus(0);
			interestGoods.setCreateTime(new Date());
		} else {
			interestGoods.setStatus(this.status);
		}
		interestGoods.setUpdateTime(new Date());
		return interestGoods;
	}
	
	public List<InterestGoodsSku> toInterestGoodsSku(Integer interestGoodsId){
		List<InterestGoodsSku> result = new ArrayList<InterestGoodsSku>();
		for (int i = 0; i < skuCode.size(); i++) {
			String code = skuCode.get(i);
			InterestGoodsSku interestGoodsSku = new InterestGoodsSku();
			interestGoodsSku.setId(ObjUtils.get(interestGoodsSkuId, i));
			interestGoodsSku.setInterestGoodsId(interestGoodsId);
			interestGoodsSku.setSkuCode(code);
			interestGoodsSku.setSkuNameCn(ObjUtils.get(skuNameCn, i));
			interestGoodsSku.setUpdateTime(new Date());
			interestGoodsSku.setQuantity(ObjUtils.get(quantity, i));
			interestGoodsSku.setDeductionPrice(ObjUtils.get(deductionPrice, i));
			if (interestGoodsSku.getId() == null) {
				interestGoodsSku.setVersion(0);
				interestGoodsSku.setReceiveQuantity(0);
				interestGoodsSku.setCashQuantity(0);
				interestGoodsSku.setCreateTime(new Date());
			}
			result.add(interestGoodsSku);
		}
		return result;
	}
	

	public Integer getId() {
		return id;
	}
	public void setId(Integer id) {
		this.id = id;
	}
	public String getProdCode() {
		return prodCode;
	}
	public void setProdCode(String prodCode) {
		this.prodCode = prodCode;
	}
	public Integer getIsFreePost() {
		return isFreePost;
	}
	public void setIsFreePost(Integer isFreePost) {
		this.isFreePost = isFreePost;
	}
	public Date getReceiptStartTime() {
		return receiptStartTime;
	}
	public void setReceiptStartTime(Date receiptStartTime) {
		this.receiptStartTime = receiptStartTime;
	}
	public Date getReceiptEndTime() {
		return receiptEndTime;
	}
	public void setReceiptEndTime(Date receiptEndTime) {
		this.receiptEndTime = receiptEndTime;
	}
	public Date getCashStartTime() {
		return cashStartTime;
	}
	public void setCashStartTime(Date cashStartTime) {
		this.cashStartTime = cashStartTime;
	}
	public Date getCashEndTime() {
		return cashEndTime;
	}
	public void setCashEndTime(Date cashEndTime) {
		this.cashEndTime = cashEndTime;
	}
	public List<String> getSkuCode() {
		return skuCode;
	}
	public void setSkuCode(List<String> skuCode) {
		this.skuCode = skuCode;
	}
	public List<Integer> getQuantity() {
		return quantity;
	}
	public void setQuantity(List<Integer> quantity) {
		this.quantity = quantity;
	}
	public Integer getStatus() {
		return status;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}
	public List<Integer> getInterestGoodsSkuId() {
		return interestGoodsSkuId;
	}
	public void setInterestGoodsSkuId(List<Integer> interestGoodsSkuId) {
		this.interestGoodsSkuId = interestGoodsSkuId;
	}
	public List<String> getSkuNameCn() {
		return skuNameCn;
	}
	public void setSkuNameCn(List<String> skuNameCn) {
		this.skuNameCn = skuNameCn;
	}
	public BigDecimal getCashThreshold() {
		return cashThreshold;
	}
	public void setCashThreshold(BigDecimal cashThreshold) {
		this.cashThreshold = cashThreshold;
	}

	public List<BigDecimal> getDeductionPrice() {
		return deductionPrice;
	}

	public void setDeductionPrice(List<BigDecimal> deductionPrice) {
		this.deductionPrice = deductionPrice;
	}

}
