package com.thebeastshop.scm.po;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import pers.richard.ormybatis.domain.po.IdPo;

public class Recommend extends IdPo {
	private String name;
	private String position;
	private String rule;
	private Date updateTime;
	private Date createTime;
	
	public Recommend(){}
	
	public final static String
		F_NAME = "name",
		F_POSITION = "position",
		F_RULE = "rule",
		F_UPDATE_TIME = "update_time",
		F_CREATE_TIME = "create_time";
	

	/** 展示位置 */
	public enum Position{
		CART("购物车");
		
		public String cn;
		private Position(String cn){
			this.cn = cn;
		}
		
		public static Map<String, String> getMap(){
			Map<String, String> map = new HashMap<>();
			for (Position position : Position.values()) {
				map.put(position.toString(), position.cn);
			}
			return map;
		}
	}
	
	/** 展示位置 */
	public enum Rule{
		RANDOM("全部随机"), ORDER("按展示顺序");
		
		public String cn;
		private Rule(String cn){
			this.cn = cn;
		}
		
		public static Map<String, String> getMap(){
			Map<String, String> map = new HashMap<>();
			for (Rule rule : Rule.values()) {
				map.put(rule.toString(), rule.cn);
			}
			return map;
		}
	}
	
	public String getName() {return name;}
	public void setName(String name) {this.name = name;}

	public String getPosition() {return position;}
	public void setPosition(String position) {this.position = position;}

	public String getRule() {return rule;}
	public void setRule(String rule) {this.rule = rule;}

	public Date getUpdateTime() {return updateTime;}
	public void setUpdateTime(Date updateTime) {this.updateTime = updateTime;}

	public Date getCreateTime() {return createTime;}
	public void setCreateTime(Date createTime) {this.createTime = createTime;}
}