package com.thebeastshop.scm.po;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import pers.richard.ormybatis.domain.po.IdPo;

public class LotteryActivityAwardType extends IdPo {
	private Integer lotteryActivityAwardId;
	private String type;
	private Date createTime = new Date();
	
	public LotteryActivityAwardType(){}
	
	public final static String
		F_LOTTERY_ACTIVITY_AWARD_ID = "lottery_activity_award_id",
		F_TYPE = "type";
	

	/** 奖品类型*/
	public enum Type{
		HAITAO("海淘商品"),
		NORMAL("普通商品");
		
		public String cn;
		private Type(String cn){
			this.cn = cn;
		}
		
		public static Map<String, String> getMap(){
			Map<String, String> map = new LinkedHashMap<>();
			for (Type type : Type.values()) {
				map.put(type.name(), type.cn);
			}
			return map;
		}
	}
	
	public Integer getLotteryActivityAwardId() {return lotteryActivityAwardId;}
	public void setLotteryActivityAwardId(Integer lotteryActivityAwardId) {this.lotteryActivityAwardId = lotteryActivityAwardId;}

	public String getType() {return type;}
	public void setType(String type) {this.type = type;}
	
	public Date getCreateTime() {return createTime;}
	public void setCreateTime(Date createTime) {this.createTime = createTime;}
}