package com.thebeastshop.scm.po;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import pers.richard.ormybatis.domain.po.IdPo;

public class LotteryActivity extends IdPo {
	private String name;
	private Date startTime;
	private Date endTime;
	private Integer consumePoint;
	private String limitType;
	private Integer limitNum;
	private Date updateTime;
	private Date createTime;
	
	public LotteryActivity(){}
	
	/** 限制抽奖类型*/ 
	public enum LimitType{
		DAY("按天限制"),
		SYS_ID("按系统ID"),
		NO("不限制");
		
		public String cn;
		private LimitType(String cn){
			this.cn = cn;
		}
		
		public static Map<String, String> getMap() {
			Map<String, String> map = new LinkedHashMap<>();
			for (LimitType type : LimitType.values()) {
				map.put(type.name(), type.cn);
			}
			return map;
		}
	}
	
	public final static String
		F_NAME = "name",
		F_START_TIME = "start_time",
		F_END_TIME = "end_time",
		F_CONSUME_POINT = "consume_point",
		F_LIMIT_TYPE = "limit_type",
		F_LIMIT_NUM = "limit_num",
		F_UPDATE_TIME = "update_time",
		F_CREATE_TIME = "create_time";
	

	public String getName() {return name;}
	public void setName(String name) {this.name = name;}

	public Date getStartTime() {return startTime;}
	public void setStartTime(Date startTime) {this.startTime = startTime;}

	public Date getEndTime() {return endTime;}
	public void setEndTime(Date endTime) {this.endTime = endTime;}

	public Integer getConsumePoint() {return consumePoint;}
	public void setConsumePoint(Integer consumePoint) {this.consumePoint = consumePoint;}
	
	public String getLimitType() {return limitType;}
	public void setLimitType(String limitType) {this.limitType = limitType;}
	
	public Integer getLimitNum() {return limitNum;}
	public void setLimitNum(Integer limitNum) {this.limitNum = limitNum;}

	public Date getUpdateTime() {return updateTime;}
	public void setUpdateTime(Date updateTime) {this.updateTime = updateTime;}

	public Date getCreateTime() {return createTime;}
	public void setCreateTime(Date createTime) {this.createTime = createTime;}
}