package com.thebeastshop.scm.es;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.po.ProdSku;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.comparators.BooleanComparator;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import pers.richard.ormybatis.domain.core.AbstractDomain;

public class PsSpvVO extends PsUpdateVO {

	private Integer spvId;
	private Integer productId;
	private String prodCode;
	private String skuCode;
	private Integer minAmount;
	private Integer combined;
	private String attrs;
	private BigDecimal salesPrice;
	private BigDecimal originalPrice;
	private List<PsAttributeValuePairVO> attributeValuePairList;
	private List<Map> skuCombinationList = new ArrayList<>();/** key:subSkuCode:子SKU编码, quantity:绑定数量  */
	private List<PsCampaignVO> campaignList;	// 所关联的SKU维度的活动列表

	private Boolean isAvaile = null;
	private Integer categoryId;

	/**
	 * 判断SPV是否可用
	 * @param chnCode
	 * @param combined
	 * @param canSaleSkuMap
	 * @param canSeeSkuMap
	 * @param spvVO
	 * @return
	 */
	public static boolean isAvaible(String chnCode, boolean combined,
									Map<String, String> canSaleSkuMap, Map<String, String> canSeeSkuMap,
									PsSpvVO spvVO) {
		if (spvVO.isAvaile != null) return spvVO.isAvaile;
		if (combined) {
			List<Map> scList = spvVO.getSkuCombinationList();
			if (CollectionUtils.isEmpty(scList)) {
				spvVO.isAvaile = false;
				return false;
			}
			for (Map sc : scList) {
				String skuCode = MapUtils.getString(sc, "subSkuCode");
				if (!PsSkuVO.isAvaible(chnCode, canSaleSkuMap, canSeeSkuMap, skuCode)) {
					spvVO.isAvaile = false;
					return false;
				}
			}
			spvVO.isAvaile = true;
			return true;
		}
		else {
			spvVO.isAvaile = PsSkuVO.isAvaible(chnCode, canSaleSkuMap, canSeeSkuMap, spvVO.getSkuCode());
			return spvVO.isAvaile;
		}
	}
	
	public PsSpvVO(){}
	
	public PsSpvVO(ProdSku ps){
		this.spvId = ps.getId();
		this.productId = ps.getProductId();
		this.prodCode = ps.getProdCode();
		this.skuCode = ps.getSkuCode();
		this.minAmount = ps.getMinAmount();
		this.combined = ps.getCombined();
		this.attrs = ps.getAttrs();
		if (ps.getCombined() == null || ps.getCombined() == 0) { // 单品
			// 取得价格：单品的情况
			this.salesPrice = ps.getSingleSkuSalesPrice();

			if (StringUtils.isNotEmpty(ps.getSkuCategoryName())) {
				// 单品属性值对
				PsAttributeValuePairVO attributeValuePairVO = new PsAttributeValuePairVO();
				attributeValuePairVO.setAttrName(ps.getSkuCategoryDesc());
				attributeValuePairVO.setValue(ps.getSkuCategoryName());
				List<PsAttributeValuePairVO> attrValuePairList = Arrays.asList(attributeValuePairVO);
				this.setAttributeValuePairList(attrValuePairList);
			}
		}
		else if (ps.getSalesPrice() != null) {   // 组合
			// 取得价格： 组合的情况
			this.salesPrice = ps.getSalesPrice();
		}
		else {
			this.salesPrice = BigDecimal.ZERO;
		}
	}

	@Override
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashedMap();
		map.put("spvId", spvId);
		map.put("productId", productId);
		map.put("prodCode", prodCode);
		map.put("skuCode", skuCode);
		map.put("minAmount", minAmount);
		map.put("combined", combined);
		map.put("categoryId", categoryId);
		if (attrs != null) {
			map.put("attrs", attrs);
		}
		if (salesPrice != null) {
			map.put("salesPrice", salesPrice);
		}
		if (attributeValuePairList != null) {
			List<Map> attrValuePairMapList = new ArrayList<>();
			for (PsAttributeValuePairVO attributeValuePairVO : attributeValuePairList) {
				attrValuePairMapList.add(attributeValuePairVO.toMap());
			}
			map.put("attributeValuePairList", attrValuePairMapList);
		}
		if (skuCombinationList != null) {
			map.put("skuCombinationList", skuCombinationList);
		}
		if(CollectionUtils.isNotEmpty(campaignList)) {
			List<Map> campaignListMap = Lists.newArrayList();
			for (PsCampaignVO item : campaignList) {
				campaignListMap.add(item.toMap());
			}
			map.put("campaignList", campaignListMap);
		}
		return map;
	}

	public Integer getSpvId() {return spvId;}
	public void setSpvId(Integer spvId) {this.spvId = spvId;}

	public Integer getProductId() {
		return productId;
	}

	public void setProductId(Integer productId) {
		this.productId = productId;
	}

	public String getProdCode() {
		return prodCode;
	}

	public void setProdCode(String prodCode) {
		this.prodCode = prodCode;
	}

	public String getSkuCode() {return skuCode;}
	public void setSkuCode(String skuCode) {this.skuCode = skuCode;}

	public Integer getMinAmount() {return minAmount;}
	public void setMinAmount(Integer minAmount) {this.minAmount = minAmount;}

	public Integer getCombined() {return combined;}
	public void setCombined(Integer combined) {this.combined = combined;}

	public String getAttrs() {
		return attrs;
	}

	public void setAttrs(String attrs) {
		this.attrs = attrs;
	}

	public BigDecimal getSalesPrice() {
		return salesPrice;
	}

	public void setSalesPrice(BigDecimal salesPrice) {
		this.salesPrice = salesPrice;
	}

	public List<PsAttributeValuePairVO> getAttributeValuePairList() {
		return attributeValuePairList;
	}

	public void setAttributeValuePairList(List<PsAttributeValuePairVO> attributeValuePairList) {
		this.attributeValuePairList = attributeValuePairList;
	}

	public List<Map> getSkuCombinationList() {return skuCombinationList;}
	public void setSkuCombinationList(List<Map> skuCombinationList) {this.skuCombinationList = skuCombinationList;}

	public List<PsCampaignVO> getCampaignList() {
		return campaignList;
	}

	public void setCampaignList(List<PsCampaignVO> campaignList) {
		this.campaignList = campaignList;
	}

	public Integer getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Integer categoryId) {
		this.categoryId = categoryId;
	}

	public BigDecimal getOriginalPrice() {
		return originalPrice;
	}

	public void setOriginalPrice(BigDecimal originalPrice) {
		this.originalPrice = originalPrice;
	}
}
