package com.thebeastshop.scm.es;

import com.thebeastshop.scm.po.SkuCustomization;
import org.springframework.util.LinkedCaseInsensitiveMap;
import pers.richard.ormybatis.domain.core.AbstractDomain;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-15
 */
public class PsSkuCustomizationVO extends AbstractDomain {

    private Long id;
    private String imageUrl;     // 定制图片
    private Integer wordsLimit;  // 限制字数
    private String description;  // 定制说明

    public PsSkuCustomizationVO() {
    }

    public PsSkuCustomizationVO(SkuCustomization skuCustomization) {
        this.id = skuCustomization.getId().longValue();
        this.imageUrl = skuCustomization.getImageUrl();
        this.wordsLimit = skuCustomization.getWordsLimit();
        this.description = skuCustomization.getDescription();
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("id", id);
        map.put("imageUrl", imageUrl);
        map.put("wordsLimit", wordsLimit);
        map.put("description", description);
        return map;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Integer getWordsLimit() {
        return wordsLimit;
    }

    public void setWordsLimit(Integer wordsLimit) {
        this.wordsLimit = wordsLimit;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
